#include "lbtypes/lbexception.hpp"
#include "luban/lbstruct.hpp"
#include "luban/lbstructinterface.hpp"
#include "luban/lbnamedargs.hpp"

#include "lbtypes/lbiterator.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/lbvector.hpp"
#include "lbtypes/lbmap.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbsymbol.hpp"


namespace Luban
{
  void LBStruct::setInput(int index, const LBObjPtr& valptr)
  {
    throw LBException("set input action is not supported for this type of struct");
  }
  void LBStruct::setInput(int index, const LBObject& val)
  {
    throw LBException("set input action is not supported for this type of struct");
  }
  void LBStruct::sync()
  {
    throw LBException("sync action is not supported for this type of struct");
  }
  bool LBStruct::linkOutputProperty(const LBSymbol& outprpname, int jointid)
  {
    throw LBException("link output property to parent composition is not supported for this type of struct");
  }
  bool LBStruct::prepareOutputForCompositionUse()
  {
    return false;
  }
  bool LBStruct::prepareOutputForProcessUse()
  {
    return false;
  }
  bool LBStruct::setRunTimeParentComposition(LBCompositionStruct *pcomp)
  {
    throw LBException("setRunTimeParentComposition is not supported for this type of struct");
  }
  bool LBStruct::wakeupAsynch()
  {
    throw LBException("wakeupAsynch is not supported for this type of struct");
  }
  bool LBStruct::initializeProperties()
  {
    return false;
  }
  // tow locally used classes
  class LBNamedArgsFromMap : public LBNamedArgs
  {
  public:
    LBNamedArgsFromMap(const LBMap& m)
      : _keys(m.size()), _vals(m.size()), _valid(false), _errmsg() 
    {
      LBConstIterator *it = m.getIterator();
      if ( ! it ) return;
      int i = 0;
      while ( it->next() )
	{
	  const LBString *keystr = dynamic_cast<const LBString*>(it->getCurrentRow()->getArg(0));
	  if ( ! keystr )
	    {
	      _errmsg = "Key is not a string type in the map type arg to struct::set() call";
	      delete it;
	      return;
	    }
	  const LBObject *val = it->getCurrentRow()->getArg(1);
	  _keys[i] = LBSymbol(keystr->str());
	  _vals[i] = val;
	  ++i;
	}

      _valid = true;
    }

    int numArgs() const
    {
      if ( _valid )
	return _keys.size();
      return 0;
    }

    const LBObject *getArg(int index ) const
    {
      if ( index <0 || index >= _keys.size() )
	return 0;
      return _vals[index];
    }

    const LBSymbol *getName(int index ) const
    {
      if ( index <0 || index >= _keys.size() )
	return 0;
      return &_keys[index];
    }

    bool valid() const
    {
      return _valid;
    }

    const string& errmsg() const
    {
      return _errmsg;
    }

  private:
    std::vector<LBSymbol> _keys;
    std::vector<const LBObject *> _vals;
    bool _valid;
    std::string _errmsg;
  };

  class LBNamedArgsFromVecs : public LBNamedArgs
  {
  public:
    LBNamedArgsFromVecs(const LBVector& keys, const LBVector& vals)
      : _keys(keys.size()), _vals(vals), _valid(false), _errmsg() 
    {
      if ( keys.size() != vals.size() )
	_errmsg = "Vector of keys and values must be of same size in call to struct::set() call";

      for( int i = 0; i < keys.size(); ++i)
	{
	  const LBString *keystr = dynamic_cast<const LBString*>(&keys[i]);
	  if ( ! keystr )
	    {
	      _errmsg = "Key is not a string type in the key vector to struct::set() call";
	      return;
	    }
	  _keys[i] = LBSymbol(keystr->str());
	}

      _valid = true;
    }

    int numArgs() const
    {
      if ( _valid )
	return _keys.size();
      return 0;
    }

    const LBObject *getArg(int index ) const
    {
      if ( index <0 || index >= _keys.size() )
	return 0;
      return &_vals[index];
    }

    const LBSymbol *getName(int index ) const
    {
      if ( index <0 || index >= _keys.size() )
	return 0;
      return &_keys[index];
    }

    bool valid() const
    {
      return _valid;
    }

    const string& errmsg() const
    {
      return _errmsg;
    }

  private:
    std::vector<LBSymbol> _keys;
    const LBVector& _vals;
    bool _valid;
    std::string _errmsg;
  };

  LBObject *LBStruct::luban_set( const LBVarArgs *args)
  {
    int numargs = args ? args->numArgs():0;
    switch ( numargs )
      {
      case 1:
	{
	  // one arg, must be map
	  const LBMap *mp = dynamic_cast<const LBMap*>(args->getArg(0));
	  if ( ! mp )
	    throw LBException("Wrong type of argument for struct::set() function, require map type for single argument call");
	  LBNamedArgsFromMap mapargs(*mp);
	  if ( ! mapargs.valid() )
    	    throw LBException("Invalid key value pair in struct::set() call: "+mapargs.errmsg());
	  setBatchProperties(&mapargs);
	  return 0;
	}
      case 2:
	{
	  // two args, can be key, value or keys, values
	  const LBObject *arg0 = args->getArg(0);
	  const LBString *onekey = dynamic_cast<const LBString*>(arg0);
	  if ( onekey )
	    {
	      LBSymbol keysym(onekey->str());
	      const LBObject *oneval = args->getArg(1);
	      if ( oneval ) 
		setProperty(keysym, *oneval);
	      else
		setProperty(keysym, LBObjPtr());
	      return 0;
	    }
	  const LBVector *keys = dynamic_cast<const LBVector*>(arg0);
	  if ( !keys )
	    throw LBException("Wrong type of arg for two-arg struct::set() call, first arg must be string or vector");  
	  const LBVector *vals = dynamic_cast<const LBVector*>(args->getArg(1));
	  if ( ! vals )
	    throw LBException("Wrong type of argument for struct::set() function, require 2nd arg to be vector too");
	      
	  LBNamedArgsFromVecs vecargs(*keys, *vals);
	  if ( ! vecargs.valid() )
    	    throw LBException("Invalid key value vectors in struct::set() call: "+vecargs.errmsg());
	  setBatchProperties(&vecargs);
	  return 0;
	}
      }

    throw LBException("Wrong number of arguments for struct::set() call");

    return 0;

  }

  LBObject *LBStruct::luban_get( const LBVarArgs *args)
  {
    int numargs = args ? args->numArgs():0;

    if ( numargs != 1 )
      throw LBException("struct::get() requires one arguement, a string or a vector of strings");
    
    const LBObject *arg0 = args->getArg(0);
    if ( ! arg0 )
      throw LBException("struct::get() requires one arguement, a string or a vector of strings");

    const LBString *key = dynamic_cast<const LBString*>(arg0);
    if ( key )
      {
	LBSymbol keysym(key->str());
	LBObjPtr val(getPropertyValue(keysym));
	if ( val )
	  return val->clone();
	return 0;
      }

    const LBVector *keys = dynamic_cast<const LBVector*>(arg0);
    int keysz = keys? keys->size():0;
    if ( keysz == 0 )
      throw LBException("struct::get() requires one arguement, a string or a non-empty vector of strings");
    
    LBVector *vals = new LBVector();
    for( int i = 0; i<keysz; ++i)
      {
	const LBString* keystr = dynamic_cast<const LBString*>(&(*keys)[i]);
	if ( ! keystr )
	  {
	    delete vals;
	    throw LBException("struct::get() requires vector of string type");
	  }
	  LBSymbol keysym( keystr->str());
	  try {
	    vals->push( getPropertyValue(keysym));
	  }
	  catch ( LBException& lbe )
	    {
	      delete vals;
	      throw LBException("Failed to get value in struct::get() member function, error message: "+lbe.msg());
	    }
      }

    return vals;

  }

  LBObject *LBStruct::luban_start( const LBVarArgs *args)
  {
    int numargs = args ? args->numArgs():0;

    if ( numargs != 0 )
      throw LBException("struct::start() requires no arguement");
    
    if ( interface().mode() != LBStructInterface::ASYNCH )
      throw LBException("struct::start() only applies to asynch struct");

    wakeupAsynch();

    return 0;

  }



}
