#include <string>

#include "lbtypes/lbtypespec.hpp"

#include "luban/lbstruct.hpp"
#include "luban/lbstructinterface.hpp"
#include "luban/lbcomponentinfo.hpp"
#include "luban/luban_parsetree.hpp"

namespace Luban
{
  using std::string;

  LBComponentInfo::~LBComponentInfo()
  {
    if ( _parsetree ) delete _parsetree;
    if ( _lubantype ) delete _lubantype;
    if ( _type == STRUCT )
      {
	// only the delete the struct not the interface pointer
	// because the struct owns the interface pointer
	if ( _struct ) delete _struct;
      }
  }

  void LBComponentInfo::invalidate( const string& errs )
  {
    _status = ERROR;
    _errmsg = errs;
  }

  const string& LBComponentInfo::errormsg( ) const
  {
    return _errmsg ;
  }


}
