#include <iostream>
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/lbvector.hpp"
#include "lbtypes/lbchar.hpp"

using Luban::LBObject;
using Luban::LBTypeFactory;
using Luban::LBInt;
using Luban::LBChar;
using Luban::LBVector;
using Luban::LBSimpleVarArgs;

using std::cout;

static void printTypeAndObj(const LBObject* obj)
{
  cout << obj->getType().toString() << " value = "<< *obj << "\n";
}

int main(int argc, char *argv[])
{

  const char *intsym("Luban::LBInt"), *doublesym("Luban::LBDouble"), *stringsym("Luban::LBString"), *charsym("Luban::LBChar"), *boolsym("Luban::LBBool"), *vectorsym("Luban::LBVector"), *mapsym("Luban::LBMap"), *setsym("Luban::LBSet");

  LBObject *intobj = LBTypeFactory::findType(intsym)->newInstance();
  LBObject *doubleobj = LBTypeFactory::findType(doublesym)->newInstance();
  LBObject *stringobj = LBTypeFactory::findType(stringsym)->newInstance();
  LBObject *charobj = LBTypeFactory::findType(charsym)->newInstance();
  LBObject *boolobj = LBTypeFactory::findType(boolsym)->newInstance();
  LBObject *vectorobj = LBTypeFactory::findType(vectorsym)->newInstance();
  LBObject *mapobj = LBTypeFactory::findType(mapsym)->newInstance();
  LBObject *setobj = LBTypeFactory::findType(setsym)->newInstance();

  LBVector *vp = dynamic_cast<LBVector*>(vectorobj);
  LBChar chara('a'), charb('b'), charc('c'),charz('z');
  vp->push(chara);
  vp->push(charb);
  vp->push(charc);
  vp->push(charz);

  const LBObject *pad[] = { vp, vp };
  LBSimpleVarArgs args(pad,2);
  LBObject *map2 = LBTypeFactory::findType(mapsym)->newInstance(&args);
  
  (*vp)[2].assign(LBChar('z'));
  
  vp->cast(setobj); //cast vector into a set
  
  LBVector v2;
  LBObject* s2 = setobj->clone();;
  map2->cast(&v2);
  map2->cast(s2);

  printTypeAndObj(intobj);
  printTypeAndObj(doubleobj);
  printTypeAndObj(stringobj);
  printTypeAndObj(charobj);
  printTypeAndObj(boolobj);
  printTypeAndObj(vectorobj);
  printTypeAndObj(mapobj);
  printTypeAndObj(setobj);
  printTypeAndObj(map2);
  printTypeAndObj(&v2);
  printTypeAndObj(s2);


  delete map2;
  delete intobj;
  delete doubleobj;
  delete stringobj;
  delete charobj;
  delete boolobj;
  delete vectorobj;
  delete mapobj;
  delete setobj;
  delete s2;
  

}
