#include <iostream>
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbsymbol.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbiterator.hpp"

int main(int argc, char *argv[])
{
  using Luban::LBString;
  using Luban::LBSymbol;
  using Luban::LBObject;
  using Luban::LBInt;
  using Luban::LBSimpleVarArgs;
  using Luban::LBException;
  using Luban::LBConstIterator;

  LBString s0("0123456789");
  std::cout<<s0<<"\n";

  LBSymbol substringfunc("substring");
  LBSymbol sizefunc("size");
  LBSymbol clearfunc("clear");

  LBInt i1(3), i2(-2);
  const LBObject *pad[] = { &i1, &i2 };
  LBSimpleVarArgs args(pad, 2);
  try {
    LBObject *s1=s0.memberFuncCall(substringfunc, &args);
  std::cout << "sub string: " << *s1 <<"\n";
  LBSimpleVarArgs args2(pad, 1);
  LBObject *s2 =   s0.memberFuncCall(substringfunc, &args2 );
  std::cout << "sub string: " << *s2 <<"\n";
  LBObject *len =   s0.memberFuncCall(sizefunc, 0 );
  std::cout << "string length: " << *len <<"\n";
  s2->assign( s0 );
  s0.memberFuncCall(clearfunc, 0 );
  delete len;
  len = s0.memberFuncCall(sizefunc, 0 );
  std::cout << "string length after clear: " << *len <<"\n";

  LBConstIterator *it = s2->getIterator();
  while ( it->next() )
    {
      const Luban::LBVarArgs *row = it->getCurrentRow();
      for( int i = 0; i < row->numArgs(); i++ )
	std::cout<< *row->getArg(i) ;
    }

  std::cout << "\n";

  delete it;
  delete len;
  delete s2;
  delete s1;
  }
  catch ( LBException l)
    {
      std::cout << l.msg() << "\n";
    }
  catch ( ... )
    {
      std::cout << "Unknown error\n";
    }
}
