#include <iostream>
#include <sstream>
#include <typeinfo>
#include <cstring>
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/HashUtil.hpp"


namespace Luban
{
  using std::ostringstream;

  class LBTypeInfo::LBTypeInfoImp
  {
  private:
    friend class LBTypeInfo;

    LBTypeInfoImp( const type_info& cppt, const char* cppname,  LBTypeInfo::LBConstructor lbc, int major, int minor) :
      _cpptype(cppt),_cppname(cppname),_lubanname(0), _defaultConstructor(lbc), _major(major), _minor(minor)  
    {
      _hash = HashFunctions::charstarHash(const_cast<char*>(_cppname));
    }
    const type_info& _cpptype;
    const char* _cppname;
    const char *_lubanname;
    LBTypeInfo::LBConstructor _defaultConstructor;
    int _major, _minor;
    int _hash;
  };

  LBTypeInfo::LBTypeInfo() 
    : _imp(0) 
  {
  }
  
  LBTypeInfo::LBTypeInfo( const type_info& cppt, const char* cppname,  LBConstructor lbc, int major, int minor) 
    : _imp(new LBTypeInfoImp( cppt, cppname, lbc, major, minor)) 
  {
  }

  string LBTypeInfo::toString() const
  { 
    return _imp->_lubanname ? string( _imp->_lubanname ):string( _imp->_cppname );
  }

  ostream& LBTypeInfo::toStream( ostream& o ) const
  { o << _imp->_cppname; return o; }

  
  int LBTypeInfo::hash() const
  {  return _imp->_hash; }

  bool LBTypeInfo::operator==(const LBTypeInfo& another) const
  { 
    return _imp == another._imp;
  }

  bool LBTypeInfo::operator>(const LBTypeInfo& another) const
  {
    if ( _imp->_hash > another._imp->_hash ) return true;
    if ( _imp->_hash < another._imp->_hash ) return false;
    if ( strcmp(_imp->_cppname, _imp->_cppname) == 1 ) return true;
    return false;
  }

  bool LBTypeInfo::operator<(const LBTypeInfo& another) const
  {
    if ( _imp->_hash < another._imp->_hash ) return true;
    if ( _imp->_hash > another._imp->_hash ) return false;
    if ( strcmp(_imp->_cppname, _imp->_cppname) < 0 ) return true;
    return false;
  }

  LBObject* LBTypeInfo::newInstance(const LBVarArgs* args) const
  {
    LBConstructor lbc = _imp->_defaultConstructor;
    if ( lbc )
      return (*lbc)(args);
    return 0;
  }


  const char* LBTypeInfo::className() const
  {      return _imp->_cppname; }

  const char* LBTypeInfo::lubanName() const
  {      return _imp->_lubanname; }

  void LBTypeInfo::setLubanName(const char* lbname)
  {  _imp->_lubanname = lbname; }

  int LBTypeInfo::majorVersion() const
  {      return _imp->_major; }

  int LBTypeInfo::minorVersion() const
  {      return _imp->_minor; }


  //static
  const LBTypeInfo* LBTypeInfo::restoreFromStream(istream& i, string &err)
  {
    static string errhead("Error to restore type ");
    static string clmnspace(" : ");
    static string errmsg;
    string tname;
    if ( i >> tname )
      {
	const char *tc = tname.c_str();
	const LBTypeInfo *lbtp = LBTypeFactory::findType(tc);
	if ( ! lbtp )
	    err += errhead+tname+clmnspace+string(LBTypeFactory::errorMessage(tc));
	return lbtp; 
      }
    
    err += "Corrupted stream or stream ended, failed to get type name from stream";
    return 0;
  }

  ostream& operator << (ostream& ost, const LBTypeInfo& lbt)
  {   return ost<<lbt.toString(); }

      
}
