#ifndef __LBSYMBOL_HPP__
#define __LBSYMBOL_HPP__

#include <string>
#include <iosfwd>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  // this one has no knowledge about Luban namespace and :: naming convention
  class LBSymbol : public LBObject
  {
    LBDECLARE(Luban::LBSymbol);
  public:
    LBSymbol();
    explicit LBSymbol(const string& str);
    explicit LBSymbol(const char* cstr);
    ~LBSymbol();

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    //LBObject optional interfaces
    int hash() const;

    // LBSymbol specific member functions
    bool operator==(const LBSymbol& x) const;
    bool operator!=(const LBSymbol& x) const
    {   return ! ( operator==(x) ); }

    class LBSymbolImp;
  private:
    LBSymbolImp *_imp;

  };


}


#endif
