#ifndef __LBERROR_HPP__
#define __LBERROR_HPP__

#include <string>
#include <iosfwd>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/RefCountedPtr.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  class LBError : public LBObject
  {
    LBDECLARE( Luban::LBError )

    // LBError constructors
    LBError();
    LBError(const char* cstr);
    LBError(const string& str);
    
    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    virtual bool equals(const LBObject& another) const;  

    // optional LBObject interface implemented
    int hash() const;
    LBError& add(const LBObject& lbo); //error message concatenation
    bool      before(const LBObject& lbo) const;

    // LBError specific interfaces
    bool operator==(const LBError& x) const;
    void clear();

    // member functions exported to Luban
    LBObject* luban_clear(const LBVarArgs *args);
    
  private:

  class LBErrorImp
  {
  public:
    string _errormsg;
    LBErrorImp(const string& s): _errormsg(s) {}
    LBErrorImp(const char* s) : _errormsg(s) {}
    LBErrorImp() : _errormsg() {}
  };

  static const RefCountedPtr<LBError::LBErrorImp>& defaultGuts()
  {
    static RefCountedPtr<LBError::LBErrorImp> dftimp( new LBError::LBErrorImp() );
    return dftimp;
  }

    RefCountedPtr<LBErrorImp> _imp;
    
  };

}


#endif
