#include <string>
#include <typeinfo>
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbchar.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"


namespace Luban
{
  using std::string;

  LBDEFINE(Luban::LBChar, 1, 0 )

  LBDEFAULT_EQUALS_FUNC( Luban::LBChar )

  LBChar* LBChar::staticConstructor(const LBVarArgs* args)
  {
    if ( args == 0 || args->numArgs() == 0 )
      return new LBChar();
    
    switch ( args->numArgs() ) {
    case 1:
      {
	const LBObject* arg0 = args->getArg(0);
	if ( arg0 == 0 )
	  return 0;

	// copy constructor
	const LBChar *cptr = dynamic_cast<const LBChar*>(arg0);
	if ( cptr )
	  return new LBChar(*cptr);
	const LBInt *iptr = dynamic_cast<const LBInt*>(arg0);
	if ( iptr )
	  return new LBChar((char)int(*iptr));
	break;
      }
    default:
      ;
    }
    
    return 0;
  }

  string LBChar::toString() const
  {
    string s;
    s += _realchar;
    return s;
  }

  ostream& LBChar::toStream(ostream& ost) const
  {
    return ost.put(_realchar);
  }

  istream& LBChar::fromStream(istream& ist, int major, int minor)
  {
    return ist.get(_realchar);
  }

  bool LBChar::cast(LBObject* target) const
  {
    LBInt *intptr = dynamic_cast<LBInt*>(target);
    if ( intptr )
      {
	*intptr = LBInt(int(_realchar));
	return true;
      }
    LBString *sptr = dynamic_cast<LBString*>(target);
    if ( sptr )
      {
	string s;
	s += _realchar;
	*sptr = LBString(s);
	return true;
      }

    return false;
  }

  bool LBChar::before(const LBObject& lbo) const
  {
    const LBChar* lboptr = dynamic_cast<const LBChar*>(&lbo);
    if ( lboptr )
	return _realchar < lboptr->_realchar;

    throw LBException(string("Can not compare LBChar with ")+lbo.getType().toString());
  }

  LBChar& LBChar::plusplus()
  {
    _realchar++;
    return *this;
  }

  LBChar& LBChar::minusminus()
  {
    _realchar--;
    return *this;
  }

}
