#include "lbthread/lbthread.hpp"
#include <iostream>
#include <string>
#include <unistd.h>

using Luban::LBRunable;
using Luban::LBMutex;
using Luban::LBMutexLocker;
using Luban::LBReadWriteLock;
using Luban::LBReadLocker;
using Luban::LBWriteLocker;
using std::string;

static LBMutex *getmutex()
{
  static LBMutex m;
  return &m;
}

static string *getSharedString()
{
  static string m;
  return &m;
}

static LBReadWriteLock *getrwlock()
{
  static LBReadWriteLock m(LBReadWriteLock::WRITER);
  return &m;
}

int main(int argc, char *argv[])
{
  using Luban::LBThread;

  class RunPrint : public LBRunable
  {
  public:
    RunPrint(const char* toprint, int num)
      : _toprint(toprint), _num(num)
    {}

    void run()
    {
      for( int i=0; i<_num; i++)
	{
	  std::cout << _toprint;
	  sleep(1);
	}
    }
  private:
    const char* _toprint;
    int _num;
  };

   RunPrint r1("00000\n", 4), r2("11111\n", 4),r3("22222\n", 4);
   // start the threads
   LBThread tr1(&r1),tr2(&r2),tr3(&r3);

   tr1.join();
   tr2.join();
   tr3.join();


  class RunPrintMut : public LBRunable
  {
  public:
    RunPrintMut(const char* toprint, int num)
      : _toprint(toprint), _num(num)
    {}

    void run()
    {
      for( int i=0; i<_num; i++)
	{
	  LBMutexLocker locker(*getmutex());
	  std::cout << _toprint;
	  sleep(1);
	}
    }
  private:
    const char* _toprint;
    int _num;
  };


   RunPrintMut rm1("$$$$$\n", 5), rm2("#####\n", 5),rm3("@@@@@\n", 5);

   // start the threads
   LBThread trm1(&rm1),trm2(&rm2),trm3(&rm3);

    trm1.join();
    trm2.join();
    trm3.join();

  class RunRead : public LBRunable
  {
  public:
    RunRead(int num)
      : _num(num)
    {}
    void run()
    {
      for( int i=0; i<_num; i++)
	{
	  string localobj;
	  {
	    LBReadLocker locker(*getrwlock());
	    localobj = *getSharedString();
	  }

	  if ( _num & 1 )
	    std::cout <<localobj  << "\n";
	  else
	    std::cout << "\"" <<localobj<< "\""  << "\n";
	  sleep(1);
	    
	}
    }
  private:
    int _num;
  };

  class RunWrite : public LBRunable
  {
  public:
    RunWrite(int num, char st)
      : _num(num), _start(st)
    {}
    void run()
    {
      for( int i=0; i<_num; i++)
	{
	  {
	    LBWriteLocker locker(*getrwlock());
	    char c=i%26 + _start;
	    *getSharedString() += c++;
	    *getSharedString() += c++;
	    *getSharedString() += c;
	  }
	  sleep(1);
	}
    }
  private:
    int _num;
    char _start;
  };

  RunWrite w1(10,'A'),w2(10,'a');
  RunRead rd1(20), rd2(19);

  LBThread  rdt1(&rd1), rdt2(&rd2),wt1(&w1), wt2(&w2);

  wt1.join();
  wt2.join();
  rdt1.join();
  rdt2.join();

}
  
