#ifndef __FILE_HPP__
#define __FILE_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Std
{
  using std::string;
  using std::istream;
  using std::ostream;
  using std::string;
  using Luban::LBObject;
  using Luban::LBVarArgs;

  class File : public LBObject
  {
    LBDECLARE( Std::File )

    enum AccessType { READ, WRITE, APPEND };
    
    File(const string& fname,  AccessType acs);

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // File specific interfaces
    bool operator==(const File& x) const
    { return false; }
    bool operator!=(const File& x) const
    { return true; }

    // File use functions
    bool put(const LBObject& obj) ; // print to human readable string
    bool putLine(const LBObject& obj) ; // print to stdout, and a CR
    bool readChar(char& c) ; // read one char
    bool readLine(string& aline) ; // read to CR
    bool readAll(string& all) ; // read until eof
    bool isValid() const { return readable() || writeable(); }
    bool readable() const;
    bool writeable() const;

    bool putObj(const LBObject& obj) ; // dump binary guts, not for human reading
    LBObject* getObj() ; // restore object from stream


    LBObject* luban_put(const LBVarArgs *args);
    LBObject* luban_putline(const LBVarArgs *args);

    LBObject* luban_get(const LBVarArgs *args);
    LBObject* luban_getline(const LBVarArgs *args);
    LBObject* luban_getall(const LBVarArgs *args);

    LBObject* luban_close(const LBVarArgs *args);

    LBObject* luban_putobj(const LBVarArgs *args);
    LBObject* luban_getobj(const LBVarArgs *args);

  private:
    string _filename;
    Luban::RefCountedPtr<std::ifstream> _rfile;
    Luban::RefCountedPtr<std::ofstream> _wfile;
  };

}



#endif
