#ifndef __LUBANPERMISSIONCHECKING_HPP__
#define __LUBANPERMISSIONCHECKING_HPP__

/************************************************
 *
 * A place to put Luban's property read/write permission policy
 *
 *****************************************************/

#include "luban/lbpropertyinfo.hpp"
#include <string>

namespace Luban
{
  class LubanPermissionChecking
  {
  public:
    static bool checkWritePermission(const LBPropertyInfo& pinfo, std::string& errs)
    {
      if ( pinfo.permission() == LBPropertyInfo::HIDDEN || pinfo.permission() == LBPropertyInfo::READONLY )
      {
	errs +="Property: "+pinfo.name().toString() +" is hidden or readonly";
	return false;
      }
    return true;
    }

    static bool checkReadPermission(const LBPropertyInfo& pinfo, bool asynch,  std::string& errs)
    {
      if ( pinfo.permission() == LBPropertyInfo::HIDDEN )
	{
	  errs +="Property: "+pinfo.name().toString() +" is a hidden property and unaccessable from outside";
	  return false;
	}
      if ( pinfo.attr() == LBPropertyInfo::IN && asynch )
	{
	  errs += "Can not read back from input property: "+pinfo.name().toString()+" from asynch struct";
	  return false;
	}

      return true;
    }
   
  };

}

#endif
