#ifndef __LUBAN_PARSETREE_HPP__
#define __LUBAN_PARSETREE_HPP__

#include <iosfwd>
#include "lbtypes/lbsymbol.hpp"
#include <cstdlib>

// general purpose parse tree 

namespace Luban

{

  class LBObject;

  class TreeNode;


  typedef TreeNode *Tree;

  class TreeNode
  {
  public:
    enum NodeType { INVALID=0, ONESOURCEUNIT, NOOP, NAMENODE, FULLNAME, NAMESPACESPEC, COMPONENTDEFLIST, ABSTRACTSTRUCT,
		    PROCESSSTRUCT, COMPOSITIONSTRUCT, STATIONARYSTRUCTDECLARE, STATIONARYSTITEMLIST, TYPENAMEDEF, ONETYPENAMES, NAMELIST,
		    DOUBLETYPE, INTTYPE, STRINGTYPE, BOOLTYPE, CHARTYPE, STRUCTTYPE, VECTORTYPE, MAPTYPE, SETTYPE, RANGETYPE, TYPENAME,
		    SYNCHSTRUCT, ASYNCHSTRUCT, INMODE, OUTMODE,  STATICMODE, STOREMODE, 
		    READONLYPMS, HIDDENPMS, READWRITEPMS,
		    TYPENAMELIST, PROPERTYLIST, EXECATTR_DEC, ONETYPEPROPERTIES, 
		    PRCPROPERTYLISTITEM, PRCSTATEMENTLIST, PRCSTATEMENT, SEQUENTIAL, DISPATCH, DISPATCHABLE, PRPBATCHSET, 
		    IFST, IFELSEST, WHILEST, FOREACHST, FORST, CONTINUEST, BREAKST, FINISHST,  
		    ASSIGNOP, ADDASSIGNOP, SUBASSIGNOP, MULASSIGNOP, DIVASSIGNOP, MODASSIGNOP, REGASSIGN,
		    WAITST, WAITFORST,CANCELST, CLOSURE_PRC, CLOSURE_COMP, TYPED_VAR_INIT, VAR_INIT_LIST, VAR_INIT_ITEM, 
		    PROPERTY, VAR_EXP, LITERAL, VECTOR_CONSTRU, 
		    CONDEXP, ADD, SUB, MUL, DIV, MOD, NEGSIGN, PLUSSIGN, NOTSIGN, PREINC, PREDEC, POSTINC, POSTDEC, 
		    EXPRESSIONLIST, NONASSIGNEXPLIST, EXPRESSION , MAP_CONSTRU, KEYVALUELIST, KEYVALUEPAIR, SET_CONSTRU, 
		    MBRFUNC, STRUCTTYPEEVAL, STRUCTOBJEVAL, CONSTR, SUBSCRIPT, 
		    ANDOP, OROP, NOTOP, EQOP, GTOP, LTOP, GEOP, LEOP, NEOP, 
		    NAMEDARGLIST, NAMEDARG, INARG, SWAPARGOP,
		    COMPCELLLIST, CELL, ASYNCHCELL, COMPOUNDCELL, STRUCT_INSTANCE, 
		    TYPEEXPLIST, TYPEEXPRESSION, MULTITYPE, STRUCT_DECLARATION,
		    PRCCOLLECTOUTPUT, STRUCTCLASSINS, COMPCOLLECTOUTPUT,
		    ENUMTYPE,LITERALLIST, NAMEDVITEM, NAMEDVLIST,
		    ISAOP, TYPEOFOP, TYPEINFOTYPE, ALLINSOFTHIS, ERRORTYPE,  CASTOP,
		    PARENTHESISEXP, VARLIST, LOCALVAR, GLOBALVAR, INPROPERTYREF, OUTPROPERTYREF, STOREPROPERTYREF,
		    STATICPROPERTYREF, COMPOUTPUT,
		    CLNPASSVECARGPAR, PASSVECARGPAR, TYPESPEC,
		    VECOP, VECOPPAR, EXPCELL,
		    STATIONARYSTPROPERTIES, STATIONARYSTPROPERTIES_ST,
		    COMPOUNDST, COMPOUNDSTPAR, STATIONARY_STRUCT_DEC };
		 


    TreeNode(NodeType nt=INVALID):_parent(0), _numChildren(0),  _nodetype(nt), _children(0), _obj(0) {};

    TreeNode(NodeType nt, Tree child1, Tree child2, Tree child3, Tree child4, Tree child5, Tree child6 ):_parent(0), _numChildren(6), _nodetype(nt), _children(0), _obj(0)
    {
      _children = new Tree[6];
      _children[0] = child1;
      _children[1] = child2;
      _children[2] = child3;
      _children[3] = child4;
      _children[4] = child5;
      _children[5] = child6;
      if ( child1 ) child1->_parent = this;
      if ( child2 ) child2->_parent = this;
      if ( child3 ) child3->_parent = this;
      if ( child4 ) child4->_parent = this;
      if ( child5 ) child5->_parent = this;
      if ( child6 ) child6->_parent = this;
    }

    TreeNode(NodeType nt, Tree child1, Tree child2, Tree child3, Tree child4, Tree child5 ):_parent(0), _numChildren(5), _nodetype(nt), _children(0), _obj(0)
    {
      _children = new Tree[5];
      _children[0] = child1;
      _children[1] = child2;
      _children[2] = child3;
      _children[3] = child4;
      _children[4] = child5;
      if ( child1 ) child1->_parent = this;
      if ( child2 ) child2->_parent = this;
      if ( child3 ) child3->_parent = this;
      if ( child4 ) child4->_parent = this;
      if ( child5 ) child5->_parent = this;
    }

    TreeNode(NodeType nt, Tree child1, Tree child2, Tree child3, Tree child4 ):_parent(0), _numChildren(4), _nodetype(nt), _children(0), _obj(0)
    {
      _children = new Tree[4];
      _children[0] = child1;
      _children[1] = child2;
      _children[2] = child3;
      _children[3] = child4;
      if ( child1 ) child1->_parent = this;
      if ( child2 ) child2->_parent = this;
      if ( child3 ) child3->_parent = this;
      if ( child4 ) child4->_parent = this;
    }

    TreeNode(NodeType nt, Tree child1, Tree child2, Tree child3):_parent(0), _numChildren(3), _nodetype(nt), _children(0), _obj(0)
    {
      _children = new Tree[3];
      _children[0] = child1;
      _children[1] = child2;
      _children[2] = child3;
      if ( child1 ) child1->_parent = this;
      if ( child2 ) child2->_parent = this;
      if ( child3 ) child3->_parent = this;
    }

    TreeNode(NodeType nt, Tree child1, Tree child2):_parent(0), _numChildren(2), _nodetype(nt), _children(0), _obj(0)
    {
      _children = new Tree[2];
      _children[0] = child1;
      _children[1] = child2;
      if ( child1 ) child1->_parent = this;
      if ( child2 ) child2->_parent = this;
    }

    TreeNode(NodeType nt, Tree child1):  _parent(0), _numChildren(1),_nodetype(nt), _children(0), _obj(0)
    {
      _children = new Tree[1];
      _children[0] = child1;
      if ( child1) child1->_parent = this;
    }

    TreeNode(NodeType nt, char* s): _parent(0), _numChildren(0), _nodetype(nt), _children(0), _obj(0)
    {
      _obj=new LBSymbol(s);
      free(s); // this is ugly, though no better way found, because this char* is from YACC and I don't want to put free into YACC action
    }

    TreeNode(LBObject *v): _parent(0), _numChildren(0), _nodetype(LITERAL), _children(0), _obj(v)
    {
    }

    virtual ~TreeNode() // kill self and downstream
    {
      pruneParent();
      int i = 0;
      for( ; i < _numChildren; i++ )
	if ( child(i) )
	  {
	    child(i)->_parent = 0;
	    delete child(i);
	  }

      if ( _numChildren ) delete[] _children;
      delete _obj; 

    }


    TreeNode* pruneChild(int idx) // this function cut the link between node self and child idx
    {
      if ( idx < 0 || idx >= _numChildren )
	return 0;
      TreeNode *c=_children[idx];
      if ( c )
	{
	  _children[idx] = 0;
	  c->_parent = 0;
	}
      return c;
    }

    void pruneParent() // this function cut the link between node self and parent
    {
      if ( _parent )
	{
	  for( int i = 0; i < _parent->_numChildren; i++ )
	    if ( _parent->_children[i] == this )
	      {
		_parent->_children[i] = 0;
		break;
	      }
	  _parent = 0;
	}
    }


    bool linkChild(int idx, TreeNode *chd) // this function cut the link between node self and child idx
    {
      if ( idx < 0 || idx >= _numChildren )
	return false;
      _children[idx] = chd;
      if ( chd )
	chd->_parent = this;
      return true;
    }

    TreeNode *clone() const // copy the node itself and downstream
    {
      TreeNode *copy = new TreeNode(*this);
      copy->_parent = 0;
      if ( _obj ) copy->_obj = _obj->clone();

      if ( _numChildren ) copy->_children = new Tree[_numChildren];

      for(int i=0 ; i < _numChildren; i++ )
	{
	  if ( _children[i] )
	    {
	      copy->_children[i] = _children[i]->clone();
	      copy->_children[i]->_parent = copy;
	    }
	  else
	    copy->_children[i] = 0;
	}
      
      return copy;
    }


    Tree parent() { return _parent; }
    Tree child(int i) { if ( _numChildren==0 || i >= _numChildren || i<0 ) return 0; else return _children[i]; } 
    bool isLeaf() const { return _numChildren==0 ; } 

    NodeType nodeType() const { return _nodetype; }

    // the symbol object will NOT be taken, so it has to be destroyed by the parse tree
    const LBSymbol* symbol() const { return dynamic_cast<const LBSymbol*>(_obj); }
    // this call takes the data object on a parse tree
    LBObject* literal() { LBObject *temp = _obj; _obj=0; return temp; }

    int numChildren() const { return _numChildren; }

    void printTree(ostream& o, int level = 0 ) const;
    void toStream(ostream& o) const;
    void fromStream(istream& i);


  private:
    TreeNode *_parent;
    int _numChildren;
    NodeType _nodetype;

    Tree *_children; 
    LBObject* _obj;

  };


}

#endif
