#ifndef __LUBAN_CODEGEN_HPP__
#define __LUBAN_CODEGEN_HPP__

#include <string>

#include "lbtypes/lbfullsymbol.hpp"

#include "luban/luban_parsetree.hpp"
#include "luban/lbvmcode.hpp"


namespace Luban
{
  using std::string;

  class LBProcessStruct;
  class LBCompositionStruct;
  class LBStruct;
  class LBStationaryStruct;
  class LBStructInterface;
  class LBTypeSpec;

  class LubanCodeGenerator
  {
  public:

    enum CodeGenStatus { FAILURE=0, SUCCESS };

    static CodeGenStatus processAUnit( Tree parsetree, LBProcessStruct* &torun, string &errs );

    static CodeGenStatus processComponents( Tree parsetree, const LBFullSymbol& homens, string &errs );

    static LBStruct *generateStructDef( Tree parsetree, LBStructInterface* ifc, const LBFullSymbol& homens, string &errs );
    static LBStructInterface *generateStructInterface( Tree parsetree, const LBFullSymbol& homens, string &errs );

    static LBTypeSpec *parseTypeDef(Tree typeexp, const LBFullSymbol& homens, string& errs);
    static LBFullSymbolVec *getTypeDefExtSymbols(Tree typeexp, const LBFullSymbol& homens);
    static LBFullSymbolVec *getTypeExpressionExtSymbols(Tree typeexp, const LBFullSymbol& homens);
    static LBTypeSpec *parseTypeExpression(Tree typeexp, const LBFullSymbol& homens, string& errs);


    static LBCompositionStruct* generateCompositionStructDef(Tree parsetree, LBStructInterface* ifc,const LBFullSymbol& homens, string &errs); 
    static LBProcessStruct* generateProcessStructDef(Tree parsetree, LBStructInterface* ifc,const LBFullSymbol& homens, string &errs); 


    // functions used internally for process struct
    static CodeGenStatus addPropertiesFromTree( Tree ptree, LBStructInterface& itfc, const LBFullSymbol& homens, string& errs);
    static CodeGenStatus addStationaryStructPropertiesFromTree(Tree ptree, LBStructInterface& itfc, const LBFullSymbol& homens, string& errs);
    static CodeGenStatus generateStatementsCode(Tree statements, LBProcessStruct &ps, LBVMCode::Operand& staticliteralop, const LBFullSymbol& homens, string& errs);
    static CodeGenStatus generateComposition(Tree compstree, LBCompositionStruct &comps, const LBFullSymbol& homens, string& errs);
    static CodeGenStatus generateStatementCode(Tree onestatement, LBProcessStruct& pstruct,  LBVMCode::Operand& staticliteralop, const LBFullSymbol& homens, string& errs);

    static CodeGenStatus generateTypedVarInitCode(Tree typedvarinit, LBProcessStruct& pstruct, LBVMCode::Operand& resultop, string& errs) ;
    static CodeGenStatus generateExpressionCode(Tree expr, LBProcessStruct& pstruct, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generatePropertyBatchSetCode(Tree expr, LBProcessStruct& pstruct, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateLValueExpCode(Tree expr, LBProcessStruct& pstruct, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateCondExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateOrExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateAndExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateNotExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateEqualityExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateTypeOfExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateRelationalExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateArithExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateMulDivExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateUnaryExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generatePostfixExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateRValueExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateAtomExpCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateNamedArgsCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;
    static CodeGenStatus generateAnonymousArgsCode(Tree exptree, LBProcessStruct& ps, LBVMCode::Operand& resultop, const LBFullSymbol& homens, string& errs) ;



    // symbol query interfaces

    // this function find the operand of a local variable or a global variable (static property of struct) or reference to other cells
    // in parent composition
    // previously non-existing local variable will be created, if necessary
    static CodeGenStatus resolveVariableOrCell(Tree fullname, LBProcessStruct& st, LBVMCode::Operand& resultvarop, const LBFullSymbol& homens, bool forwriting, string& errs);


    // functions used internally for process struct
    static CodeGenStatus processNamedArgsForTypedCell(int cellid, LBCompositionStruct& comps, TreeNode *namedargs, const LBFullSymbol& homens, string& errs);    

  };


}

#endif
