#ifndef __LBTYPESPECSTRUCT_HPP__
#define __LBTYPESPECSTRUCT_HPP__

#include <iosfwd>
#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

#include "luban/lbstructinterface.hpp"

namespace Luban
{
  class LBStruct;
  using std::string;

  class LBTypeSpecStruct : public LBTypeSpec
  {
    LBDECLARE(Luban::LBTypeSpecStruct);
  public:

    LBTypeSpecStruct();
    explicit LBTypeSpecStruct( const LBStructInterface* st );
    explicit LBTypeSpecStruct( LBStructInterface::ExecMode m );
    ~LBTypeSpecStruct();

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    // LBTypeSpec required interface
    bool checkObj(const LBObject& obj) const;
    LBObject *createObj(const LBVarArgs* args) const;

    // LBTypeSpecStruct specific member functions
    const LBStructInterface* getStructInterface() const;
    bool operator==(const LBTypeSpecStruct& x) const;
    bool operator!=(const LBTypeSpecStruct& x) const
    {   return ! ( operator==(x) ); }

  private:
    const LBStructInterface* _structitfc;
    LBStructInterface::ExecMode _mode;

  };


}

#endif
