#ifndef __LBLOCALPROEPRTYSTORAGE_HPP__
#define __LBLOCALPROEPRTYSTORAGE_HPP__

#include <vector>

#include "lbtypes/LBObjPtr.hpp"
#include "lbthread/lbthread.hpp"
#include "luban/lbrwlockedobjptr.hpp"

namespace Luban
{
  class LBObject;

  class LocalPropertyStorage
  {
  public:
    LocalPropertyStorage(int sz, bool allthreading = false);

    void initThreading(int index);

    LBObjPtr readValue(int index) const;
    LBObject* getUnsharedPtr(int index);
    bool writeValue(int index, const LBObjPtr& objptr);
    bool writeValue(int index, const LBObject& obj);
      
    LBWriteLockedObjPtr getWriteLockedObj(int index);

  private:
    class ValueStruct
    {
    public:
      ValueStruct()
	: _value(), _rwlock(0)
      {}
      ValueStruct(const ValueStruct& v)
	: _value(v._value), _rwlock(0)
      {
	if ( v._rwlock )
	  _rwlock = new LBReadWriteLock();
      }
      ~ValueStruct() { if ( _rwlock ) delete _rwlock; }
      LBObjPtr _value;
      LBReadWriteLock *_rwlock;
    };

    std::vector<ValueStruct> _properties;

  };

}

#endif
  
