#ifndef __LBCOUNTERWAITER_HPP__
#define __LBCOUNTERWAITER_HPP__

#include "lbthread/lbthread.hpp"

namespace Luban
{
  class CounterWaiter
  {
  public:
    CounterWaiter(bool downwatch=true);

    bool inc();
    bool dec();
    bool waitDownToZero();
    bool waitUpFromZero();
    bool reset();
    void dismissWaitingThreads();
  private:
    CounterWaiter(const CounterWaiter& cw);
    CounterWaiter& operator=(const CounterWaiter& cw);
 
    int _num;
    LBMutex _pmutex;
    LBCondVar _zerocondition;
    bool _downwatch;
    bool _dismissed;
  };


}

#endif
