#include "lbthread/lbthread.hpp"
#include "luban/lbcounterwaiter.hpp"

namespace Luban
{
  CounterWaiter::CounterWaiter(bool downwatch) 
    : _num(0), _pmutex(), _zerocondition(), _downwatch(downwatch), _dismissed(false)
  {}


  bool CounterWaiter::inc()
  {
    LBMutexLocker mlock(_pmutex);
    ++_num;
    if ( ! _downwatch )
      _zerocondition.broadcast();
    return true;
  }

  bool CounterWaiter::dec()
  {
    LBMutexLocker mlock(_pmutex);
    --_num;
    if ( _downwatch )
      _zerocondition.broadcast();
    return true;
  }

  bool CounterWaiter::waitDownToZero()
  {
    if ( ! _downwatch ) return false;
    {
      if ( _dismissed ) return false;
      LBMutexLocker mlock(_pmutex);
      if ( _dismissed ) return false;
      while ( _num > 0 )
	{
	  _zerocondition.wait(_pmutex);
	  if ( _dismissed ) return false;
	}
    }
    return true;
  }

  bool CounterWaiter::waitUpFromZero()
  {
    if ( _downwatch ) return false;
    {
      if ( _dismissed ) return false;
      LBMutexLocker mlock(_pmutex);
      if ( _dismissed ) return false;
      while ( _num == 0 )
	{
	  _zerocondition.wait(_pmutex);
	  if ( _dismissed ) return false;
	}
    }
    return true;
  }

  bool CounterWaiter::reset()
  {
    LBMutexLocker mlock(_pmutex);
    _num = 0;
    _zerocondition.broadcast();
    return true;
  }

  void CounterWaiter::dismissWaitingThreads()
  {
    LBMutexLocker mlock(_pmutex);
    _dismissed = true;
    _zerocondition.broadcast();
  }

}
