#ifndef __LBTYPEEXP_HPP__
#define __LBTYPEEXP_HPP__

namespace Luban
{
  class LBTypeExp : public LBObject
  {
  public:
    LBTypeExp(const LBTypeInfo& t); // start from a single type as root
    
    // finish it by setting its branch, or expanding into multi type
    void addType(const LBTypeExp& alsoallowedtype); 
    bool setContainedType(int dimension, const LBTypeExp& containedtype); // for container type, set the type limit for elements

    // major functionalities: check type against instance
    bool check(const LBObject& obj) const;
    bool checkAndImpose(LBContainer* container) const;
    //check if another type exp is in compliance with this
    // example vector<int> is in compliance with vector<object>
    bool compliance(const LBTypeExp& another) const ; 

  private:
    LBTypeTree _typetree;
  }


}


#endif
