#ifndef __LBDOUBLE_HPP__
#define __LBDOUBLE_HPP__

#include <string>
#include <iosfwd>
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/lbobject.hpp"

namespace Luban
{
  using std::string;

  class LBDouble : public LBObject
  {
    LBDECLARE( Luban::LBDouble )
    
    // LBDouble constructors
    LBDouble(double x=0.0): _realdouble(x) {}


    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    virtual bool equals(const LBObject& another) const;  

    // optional LBObject interface implemented
    int hash() const;
    bool cast(LBObject* target ) const; // cast self to the new type, return a new object
    LBDouble& add(const LBObject& lbo);
    LBDouble& sub(const LBObject& lbo);
    LBDouble& mul(const LBObject& lbo);
    LBDouble& div(const LBObject& lbo);
    bool      before(const LBObject& lbo) const;
    LBDouble& neg();
    LBDouble& plusplus();
    LBDouble& minusminus();

    // LBDouble specific interfaces
    bool operator==(const LBDouble& x) const
    { return _realdouble == x._realdouble; }
    bool operator!=(const LBDouble& x) const
    { return _realdouble != x._realdouble; }
    operator double() const
    {  return _realdouble; }
    operator int() const
    {  return int(_realdouble); }
    double data() const
    {   return _realdouble; }

    friend class LBInt;

    // exported member function
    LBObject* luban_format(const LBVarArgs *args);

  private:
    double _realdouble;

  };

}

#endif
