#include "lbtypes/AtomicInt.hpp"

// This is the platform dependent implementation of the atomic int

#include "lbthread/lbthread.hpp"

namespace Luban
{
  class AtomicInt::AtomicIntImp
  {

    // this is an temp implementation, should use better implementation in future
  public:
    AtomicIntImp(int initval)
      : _lock(), _data(initval)
    {}
    ~AtomicIntImp()
    {}
    LBMutex _lock;
    int _data;
  private:
    AtomicIntImp(const AtomicIntImp& a);
    AtomicIntImp& operator=(const AtomicIntImp& a);

  };

  AtomicInt::AtomicInt(int initval)
    : _imp( new AtomicIntImp(initval) )
  {}

  AtomicInt::~AtomicInt()
  {
    delete _imp;
  }

  int AtomicInt::inc()
  {
    LBMutexLocker mlock(_imp->_lock);
    return ++_imp->_data;
  }

  int AtomicInt::dec()
  {
    LBMutexLocker mlock(_imp->_lock);
    return --_imp->_data;
  }

  int AtomicInt::compareTo(int i)
  {
    LBMutexLocker mlock(_imp->_lock);
    if ( _imp->_data > i ) return 1;
    if ( _imp->_data == i ) return 0;
    return -1;
  }

  void AtomicInt::set(int i)
  {
    LBMutexLocker mlock(_imp->_lock);
    _imp->_data = i;
  }

}
