#include <iostream>
#include <string>

#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbchar.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"

#include "lbstd/console.hpp"


namespace Std
{
  using std::string;
  using std::cin;
  using std::cout;

  using Luban::LBObject;
  using Luban::LBChar;
  using Luban::LBInt;
  using Luban::LBString;
  using Luban::LBVarArgs;
  using Luban::LBSymbol;
  using Luban::LBException;

  LBDEFINE(Std::Console, 1, 0 )

  LBDEFAULT_STATIC_CONSTRUCTOR(Std::Console)
  LBDEFAULT_EQUALS_FUNC(Std::Console)

  Console::Console()
  {
    cin.clear();
  }

  string Console::toString() const
  {
    static const string s("std::console");
    return s;
  }

  ostream& Console::toStream(ostream& ost) const
  {
    return ost;
  }

  istream& Console::fromStream(istream& ist, int major, int minor)
  {
    cin.clear();
    return ist;
  }

  void Console::put(const LBObject& obj) const
  {
    cout<<obj.toString();
  }

  void Console::putLine(const LBObject& obj) const
  {
    cout<<obj.toString()<<'\n';
  }

  bool Console::readChar(char& c) const
  {
    c=cin.get();
    return cin;
  }
   
  bool Console::readLine(string& aline) const
  {
    return getline(cin, aline);
  }

  bool Console::readAll(string& all) const
  {
    char c;
    while(cin && cin.get(c) )
      all += c;
    return true;
  }


  bool Console::putObj(const LBObject& obj)
  {
    LBObject::instanceToStream(cout, obj);
    return true;
  }

  LBObject* Console::getObj()
  {
    string errs;
    LBObject *obj = LBObject::instanceFromStream(cin,errs );
    if ( obj )
      return obj;
    throw LBException("Failed to restore object from stdin: "+errs);
    return 0;
  }


  LBEXPORT_MEMBER_FUNC(Std::Console, luban_putobj, "writeobj", "void writeobj(obj1, obj2, obj3....)" ); 
  LBObject* Console::luban_putobj(const LBVarArgs *args)
  {
    if ( ! args || args->numArgs() == 0 )
      return 0;
    for( int i=0; i<args->numArgs(); i++)
      {
	const LBObject *obj = args->getArg(i);
	if ( obj ) 
	  putObj( *obj );
	else
	  throw LBException("Can not persist null value guts");
      }
    return 0;
  }

  LBEXPORT_MEMBER_FUNC(Std::Console, luban_getobj, "readobj", "object readobj()" ); 
  LBObject* Console::luban_getobj(const LBVarArgs *args)
  {
    if ( args && args->numArgs() != 0 )
      throw LBException("std::console::readobj() does not take arguements");
    return getObj();
  }

    
  LBEXPORT_MEMBER_FUNC(Std::Console, luban_put, "write", "void write(obj1, obj2, obj3....)" ); 
  LBObject* Console::luban_put(const LBVarArgs *args)
  {
    if ( ! args || args->numArgs() == 0 )
      return 0;
    for( int i=0; i<args->numArgs(); i++)
      {
	const LBObject *obj = args->getArg(i);
	if ( obj ) 
	  cout << obj->toString();
	else
	  cout << "null";
      }
    return 0;
  }

  LBEXPORT_MEMBER_FUNC(Std::Console, luban_putline, "writeline", "void writeline(obj1, obj2, obj3....)" ); 
  LBObject* Console::luban_putline(const LBVarArgs *args)
  {
    if ( ! args || args->numArgs() == 0 )
      {
	cout <<'\n';
	return 0;
      }
    for( int i=0; i<args->numArgs(); i++)
      {
	const LBObject *obj = args->getArg(i);
	if ( obj ) 
	  cout << obj->toString();
	else
	  cout << "null";
      }
    cout<<'\n';
    return 0;
  }

  LBEXPORT_MEMBER_FUNC(Std::Console, luban_get, "read", "string read(int NumToRead=1)" ); 
  LBObject* Console::luban_get(const LBVarArgs *args)
  {
    int toread = 1;
    if ( args && args->numArgs() ) 
      {
	if ( args->numArgs() != 1 )
	  throw LBException("file::read function take one integer argument");

	const LBInt *n = dynamic_cast<const LBInt*>(args->getArg(0));
	if ( ! n )
	  throw LBException("file::read function take one integer argument");	      
	toread = int(*n);
      }

    char c;
    string s;
    while ( --toread >= 0 && readChar(c) )
      s += c;
    return new LBString(s);
  }

  LBEXPORT_MEMBER_FUNC(Std::Console, luban_getline, "readline", "string readline()" ); 
  LBObject* Console::luban_getline(const LBVarArgs *args)
  {
    if ( args && args->numArgs() )
      {
	throw LBException("console::getline() does not take arguments");
	return 0;
      }
    string ln;
    if ( readLine(ln) )
      return new LBString(ln);
    return 0;
  }

  LBEXPORT_MEMBER_FUNC(Std::Console, luban_getall, "readall", "string readall()" ); 
  LBObject* Console::luban_getall(const LBVarArgs *args)
  {
    if ( args && args->numArgs() )
      {
	throw LBException("console::getall() does not take arguments");
	return 0;
      }
    string ln;
    if ( readAll(ln) )
      return new LBString(ln);
    return 0;
  }



}
