#include <cstdlib>
#include <fstream>
#include <sstream>
#include <string>

#include "lbtypes/lbfullsymbol.hpp"
#include "lbtypes/lbtypefactory.hpp"

#include "luban/luban_symbolresolver.hpp"
#include "luban/luban_import.hpp"

namespace Luban
{
  using std::cerr;
  using std::string;
  using std::istringstream;
 
  static const char *basictypelist_env="LubanImportTypeList";
  static const char *basictypelist_default="LubanImportTypes";
  
  // static
  int LubanImporter::importBasicTypes(const char* listfilename)
  {
    const char *fname = listfilename;
    if ( !fname )
      {
	fname = getenv(basictypelist_env);
	if ( ! fname )
	  fname = basictypelist_default;
      }
  
    std::ifstream typelist(fname);

    if ( ! typelist )
      return 0;

    int total=0;
    while( typelist )
      {
	string aline;
	getline(typelist, aline);
	if ( typelist )
	  {
	    istringstream ist(aline);
	    string lubanname, cppname, dllname;
	    ist >> cppname;
	    ist >> dllname;
	    ist >> lubanname;

	    if ( lubanname.size() > 0 )
	      {
		if ( LBTypeFactory::registerDLL(strdup(cppname.c_str()),strdup(dllname.c_str()),strdup(lubanname.c_str())) == 0 )
		  {
		    cerr << "Can not register type "<< cppname<<" due to possible name confliction\n";
		    continue;
		  }
		    
		LBFullSymbol fsym;
		if ( ! LBFullSymbol::stringToFullSymbol(lubanname, fsym) )
		  {
		    cerr << "Invalid line in import type list: "<< aline<<'\n';
		    continue;
		  }
		string errs;
		if ( ! LubanSymbolResolver::addImportedType(fsym, errs) )
		  {
		    cerr << "Can not import type "<< lubanname<< " into Luban: "<< errs;
		    continue;
		  }
		
	      }
	    else
	      if ( LBTypeFactory::registerDLL(strdup(cppname.c_str()),strdup(dllname.c_str())) == 0 )
		{
		  cerr << "Can not register type "<< cppname<<" due to possible name confliction\n";
		  continue;
		}

	    total++;

	  }
      }

    return total;

  }

}
