#ifndef __LBSTRUCTIOPAD_HPP__
#define __LBSTRUCTIOPAD_HPP__

#include "lbtypes/LBObjPtr.hpp"
#include "lbtypes/lbexception.hpp"

namespace Luban
{
  class LBObject;
  class LBCompositionStruct;

  class LBStructInPad
  {
  public:
    virtual ~LBStructInPad() {}

    virtual bool writeValueByExternal(int index, const LBObjPtr& obj) = 0;
    virtual bool writeValueByExternal(int index, const LBObject& obj) = 0;
    virtual LBObjPtr readValueByInternal(int index) = 0;
    virtual LBObject* readUnsharedGuts( int index ) = 0;
    virtual int size() const = 0;
    virtual LBStructInPad *clone() const = 0;
    virtual int waitForNewInput() { return 0; }
    virtual void waitUntilInputEmpty() {}
    virtual void dismissWaitingThreads() {} // only applies to LBStructInPadAsynch for process
  };

  class LBStructOutPad
  {
  public:
    virtual ~LBStructOutPad() {}

    virtual bool writeValueByInternal(int index, const LBObjPtr& obj) = 0;
    virtual bool writeValueByInternal(int index, const LBObject& obj) = 0;
    virtual LBObjPtr readValueByExternal(int index) = 0;
    virtual int size() const = 0;
    virtual LBStructOutPad *clone() const = 0;
    // below only appies to output pad of structs used in composition
    virtual void flush() { throw LBException("flush not available for this output pad"); } // only for synch struct
    virtual void linkTo(int idx, int jointid ) { throw LBException("linkTo not available for this output pad"); }
    virtual void setParentComposition(LBCompositionStruct *parentcomp)
    { throw LBException("setParentComposition not applicable to this output pad"); }
    virtual void dismissWaitingThreads() {} // only applies to LBStructOutPadAsynch for process

  };


}

#endif
