#include "luban/lblocalpropertystorage.hpp"

#include "lbtypes/LBObjPtr.hpp"
#include "lbtypes/lbobject.hpp"

#include "lbthread/lbthread.hpp"

#include "luban/lbrwlockedobjptr.hpp"
#include "luban/lbstruct.hpp"
#include "luban/lbstructinterface.hpp"

namespace Luban
{
  static inline bool isAsynchStruct(const LBObject *obj)
  {
    const LBStruct *s = dynamic_cast<const LBStruct*>(obj);
    if ( s && s->interface().mode() == LBStructInterface::ASYNCH )
      return true;
    return false;
  }

  LocalPropertyStorage::LocalPropertyStorage(int sz, bool allthreading)
    : _properties(sz)
  {
    if ( allthreading )
      for( int i = 0; i < sz ; i++)
	_properties[i]._rwlock = new LBReadWriteLock();
  }

  void LocalPropertyStorage::initThreading(int index)
  {
    if ( ! _properties[index]._rwlock )
      _properties[index]._rwlock = new LBReadWriteLock();
  }

  LBObjPtr LocalPropertyStorage::readValue(int index) const
  {
    LBReadWriteLock *rwlock = _properties[index]._rwlock;
    if ( rwlock  )
      {
	LBReadLocker rlocker( *rwlock );
	return _properties[index]._value;
      }
    return _properties[index]._value;
  }

  LBObject* LocalPropertyStorage::getUnsharedPtr(int index)
  {
    LBReadWriteLock *rwlock = _properties[index]._rwlock;
    if ( rwlock  )
      {
	LBReadLocker rlocker( *rwlock );
	uniclone(_properties[index]._value);
	return _properties[index]._value.getRealPtr();
      }
    return _properties[index]._value.getRealPtr();
  }

  bool LocalPropertyStorage::writeValue(int index, const LBObjPtr& obj)
  {
    LBReadWriteLock *rwlock = _properties[index]._rwlock;
    if ( rwlock  )
      {
	LBWriteLocker wlocker( *rwlock );
	_properties[index]._value = obj;
	return true;
      }
    _properties[index]._value = obj;
    return true;
  }


  bool LocalPropertyStorage::writeValue(int index, const LBObject& obj)
  {
    LBReadWriteLock *rwlock = _properties[index]._rwlock;
    if ( rwlock  )
      {
	LBWriteLocker wlocker( *rwlock );
	_properties[index]._value.assign(obj);
	return true;
      }

    _properties[index]._value.assign(obj);
    return true;
  }


  LBWriteLockedObjPtr LocalPropertyStorage::getWriteLockedObj(int index)
  {
    if ( ! _properties[index]._value )
      return LBWriteLockedObjPtr();

    LBReadWriteLock *rwlock = _properties[index]._rwlock;
    if ( rwlock  )
      {
	LBWriteLockedObjPtr wlockedobj( rwlock, 0);

	// special treatment for asynch struct
	// because the semantic of asynch struct is different from normal data obj
	// This is a hack to fit a live fish into a dead fish pool
	// strategy is two sided:
	//   a. Always copy instead of ref counting when assign an asynch struct
	//   b. No obtaining of exclusive copy in "getWriteLockedObjPtr" operation
	//      because the sharing of the object means to share the same copy
	if ( ! isAsynchStruct(_properties[index]._value.getConstRealPtr()) )
	  uniclone( _properties[index]._value);

	wlockedobj.pushObj(_properties[index]._value.getRealPtr());
	return wlockedobj;
      }
    if ( ! isAsynchStruct(_properties[index]._value.getConstRealPtr()) )
      uniclone( _properties[index]._value);
    return LBWriteLockedObjPtr(0, _properties[index]._value.getRealPtr());

  }

}
