#ifndef __LBTYPESPECENUM_HPP__
#define __LBTYPESPECENUM_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/lbset.hpp"

namespace Luban
{
  using std::string;
  
  class LBTypeSpecEnum : public LBTypeSpec
  {
    LBDECLARE(Luban::LBTypeSpecEnum);
  public:
    LBTypeSpecEnum() : _enum() {}
    ~LBTypeSpecEnum() {}

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    // LBTypeSpec required interface
    bool checkObj(const LBObject& obj) const
    { return _enum.contains(&obj); }

    // LBObject optional interface
    int size() const
    { return _enum.size(); }

    // LBTypeSpecBasic specific member functions
    void addEnum(const LBObject& enumobj)
    { _enum.insert(&enumobj); }
    void addEnum(LBObject* enumobj) // take the ownership
    { _enum.insert(enumobj); }
    bool operator==(const LBTypeSpecEnum& x) const
    {  return _enum == x._enum; }
    bool operator!=(const LBTypeSpecEnum& x) const
    {   return ! ( operator==(x) ); }

  private:
    LBSet _enum;

  };


}

#endif
