#ifndef __LBTYPESPECBASIC_HPP__
#define __LBTYPESPECBASIC_HPP__

#include <iosfwd>
#include <string>

#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  class LBTypeInfo;

  class LBTypeSpecBasic : public LBTypeSpec
  {
    LBDECLARE(Luban::LBTypeSpecBasic);
  public:
    LBTypeSpecBasic() : _realtype(0) {}
    explicit LBTypeSpecBasic( const LBTypeInfo* tinfo ) 
      : _realtype(tinfo)  {}
    explicit LBTypeSpecBasic( const LBTypeInfo& tinfo ) 
      : _realtype(&tinfo) {}
    ~LBTypeSpecBasic() {}

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    //LBObject optional interfaces
    int hash() const
    { if ( _realtype ) return _realtype->hash(); return 0; } 

    // LBTypeSpec required interface
    bool checkObj(const LBObject& obj) const
    {   
      if ( _realtype ) 
	return &(obj.getType()) == _realtype || obj.getType() == *_realtype ; 
      return true; 
    }

    LBObject *createObj(const LBVarArgs *args) const
    {
      return _realtype->newInstance(args);
    }

    // LBTypeSpecBasic specific member functions
    bool operator==(const LBTypeSpecBasic& x) const
    {  return _realtype == x._realtype; }
    bool operator!=(const LBTypeSpecBasic& x) const
    {   return ! ( operator==(x) ); }

    const LBTypeInfo* typeInfo() const { return _realtype; }

  private:
    const LBTypeInfo* _realtype;

  };


}

#endif
