#ifndef __LBINT_HPP__
#define __LBINT_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  class LBInt : public LBObject
  {
    LBDECLARE( Luban::LBInt )
    
    // LBDouble constructors
    LBInt(int x=0): _realint(x) {}


    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    virtual bool equals(const LBObject& another) const;  

    // optional LBObject interface implemented
    int hash() const;
    // no need to handle string in the below cast operation
    bool cast(LBObject* target ) const; // cast self to the target type, assign to target
    LBInt& add(const LBObject& lbo);
    LBInt& sub(const LBObject& lbo);
    LBInt& mul(const LBObject& lbo);
    LBInt& div(const LBObject& lbo);
    LBInt& mod(const LBObject& lbo);
    bool      before(const LBObject& lbo) const;
    LBInt& neg();
    LBInt& plusplus();
    LBInt& minusminus();


    // LBInt specific interfaces
    bool operator==(const LBInt& x) const
    { return _realint == x._realint; }
    bool operator!=(const LBInt& x) const
    { return _realint != x._realint; }
    operator int() const
    {  return _realint; }
    operator double() const
    {  return double(_realint); }
    int data() const
    {   return _realint; }

    
    friend class LBDouble;

  private:
    int _realint;

  };

}

#endif
