#ifndef __LBCHAR_HPP__
#define __LBCHAR_HPP__

#include <string>
#include <iosfwd>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Luban
{
  using std::string;

  class LBChar : public LBObject
  {
    LBDECLARE( Luban::LBChar )
    
    // constructors
    LBChar(char x='\0'): _realchar(x) {}

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // optional LBObject interface implemented
    int hash() const { return _realchar; }
    // no need to handle string in the below cast operation
    bool cast(LBObject* target ) const; // cast self to the target type, assign to target
    bool  before(const LBObject& lbo) const;
    LBChar& plusplus(); // return reference to self
    LBChar& minusminus(); // return reference to self



    // LBChar specific interfaces
    bool operator==(const LBChar& x) const
    { return _realchar == x._realchar; }
    bool operator!=(const LBChar& x) const
    { return _realchar != x._realchar; }
    bool operator<(const LBChar& x) const
    { return _realchar < x._realchar; }
    operator char() const
    {  return _realchar; }
    char data() const
    {   return _realchar; }

  private:
    char _realchar;
  };

}


#endif
