#ifndef __LBMEMBERFUNCTABLE_HPP__
#define __LBMEMBERFUNCTABLE_HPP__

#include "lbtypes/HashUtil.hpp"
#include "lbtypes/lbsymbol.hpp"
#include <iostream>

namespace Luban
{
  class LBObject;
  class LBVarArgs;

  template<class T> class LBMemberFuncTable
  {
  private:
    static int hashsym(const LBSymbol& s) { return s.hash(); }
    static bool equalsym(const LBSymbol& s1, const LBSymbol& s2) { return s1 == s2; }
  public:
    LBMemberFuncTable() : _mftable(&hashsym, &equalsym, 5),_synopsistable(&hashsym, &equalsym, 5) { }
    int addMemberFunc(const char* lubanname, typename T::LubanCallable memberfptr, const char* synopsis)
    {
      LBSymbol s(lubanname);
      _mftable[s] = memberfptr; 
      _synopsistable[s]=const_cast<char*>(synopsis);
      return 1;
    }
    bool find(const LBSymbol& lubanname, typename T::LubanCallable& fptr)
    {  return _mftable.find(lubanname, fptr); }
    const LBHashMap<LBSymbol, char*>& allfuncs() const
    {  return _synopsistable; }
  private:
    LBHashMap<LBSymbol, typename T::LubanCallable> _mftable;
    LBHashMap<LBSymbol, char*> _synopsistable;
  };



}


#endif
