#ifndef __LBMACROS_HPP__
#define __LBMACROS_HPP__

#include <typeinfo>
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/LBMemberFuncTable.hpp"
#include "lbtypes/lbexception.hpp"

// These are the macros to save a lot of typing
// LBDECLARE to be used in header files
// and LBDEFINE used in cpp files to define those declared in LBDECLARE
// A trick to make compiler do typing.
// These macros are only used in SOLID derived class of LBObject
// do not and no need to use it in an abstract class derived from LBObject
//
// What are declared and defined
// 1. virtual clone() function
// 2. virtual bool assign() function which tries to down cast the input then call
//    the assingment operator for the class, return false if unsuccessful
// 3. virtual getType() function returning an instance of its LBTypeInfo
// 4. static ClassName::getInstance() function which returns a default instance


class Luban::LBTypeInfo;
class Luban::LBSymbol;
class Luban::LBVarArgs;

#define LBDECLARE( CPPClassName )                        \
public:                                                  \
  static int factoryRegistered;                          \
  static const Luban::LBTypeInfo& staticTypeInfo();             \
  CPPClassName* clone() const;                           \
  bool assign( const LBObject& lbo);                     \
  const Luban::LBTypeInfo& getType() const;                      \
  static CPPClassName* staticConstructor(const Luban::LBVarArgs *args=0) ; \
  typedef Luban::LBMemberFuncTable<CPPClassName>::LubanCallable LubanCallableFunc;  \
  static Luban::LBMemberFuncTable<CPPClassName>& exportedMemeberFuncRegistry();    \
  static int exportMemberFunc(const char* lubanname, LubanCallableFunc f, const char* synopsis);    \
  Luban::LBObject* memberFuncCall(const Luban::LBSymbol& funcname, const Luban::LBVarArgs* lbargs, Luban::LBObject *returnvalue=0);   \



#define LBDEFAULT_STATIC_CONSTRUCTOR(CPPClassName)                            \
  CPPClassName* CPPClassName::staticConstructor(const LBVarArgs *args)        \
  {  return new CPPClassName;  }                                              \


#define LBDEFAULT_EQUALS_FUNC(CPPClassName)                                           \
  bool CPPClassName::equals(const LBObject& x) const                                  \
  {                                                                                   \
    const CPPClassName *ptr = dynamic_cast<const CPPClassName*>(&x);  \
    if ( ptr  )                                                                       \
      return operator==(*ptr);                                                      \
    return false;                                                                     \
  }                                                                             \




#define LBDEFINE( CPPClassName, majorversion, minorversion )               \
  int CPPClassName::factoryRegistered =Luban::LBTypeFactory::registerType( const_cast<Luban::LBTypeInfo*>(&staticTypeInfo()) ); \
  CPPClassName* CPPClassName::clone() const                   \
  {  return new CPPClassName(*this); }                        \
  bool CPPClassName::assign( const LBObject& lbo)             \
  {                                                           \
       const CPPClassName* ptr = dynamic_cast<CPPClassName*>(const_cast<LBObject*>(&lbo)); \
       if ( ! ptr ) return false;                             \
       *this = *ptr;                                          \
       return true;                                           \
  }                                                           \
  const Luban::LBTypeInfo& CPPClassName::staticTypeInfo()                   \
  {                                                           \
     static Luban::LBTypeInfo lbt(typeid(CPPClassName), #CPPClassName, (Luban::LBTypeInfo::LBConstructor)&CPPClassName::staticConstructor, majorversion, minorversion); \
     return lbt;                                               \
  }                                                               \
  const Luban::LBTypeInfo& CPPClassName::getType() const                    \
  {      return staticTypeInfo(); }                           \
  CPPClassName* CPPClassName::staticConstructor(const LBVarArgs *args)        \
  {  return new CPPClassName;  }                                             \
  Luban::LBMemberFuncTable<CPPClassName>& CPPClassName::exportedMemeberFuncRegistry()    \
{  throw LBException(string(#CPPClassName)+string(" is not expored to Luban")); } \
  Luban::LBObject* CPPClassName::memberFuncCall(const Luban::LBSymbol& funcname, const Luban::LBVarArgs* lbargs, Luban::LBObject *returnvalue=0) \
 {  throw LBException(string(#CPPClassName)+string(" is not exported to Luban")); } \
 int CPPClassName::exportMemberFunc(const char* lubanname, LubanCallableFunc f, const char* synopsis)    \
 {  throw LBException(string(#CPPClassName)+string(" is not exported to Luban")); } \



#define LBDEFINE_AND_EXPORT( CPPClassName, majorversion, minorversion, LubanFullTypeName )               \
  int CPPClassName::factoryRegistered =Luban::LBTypeFactory::registerType( const_cast<Luban::LBTypeInfo*>(&staticTypeInfo()), const_cast<char*>(LubanFullTypeName) ); \
  CPPClassName* CPPClassName::clone() const                   \
  {  return new CPPClassName(*this); }                        \
  bool CPPClassName::assign( const LBObject& lbo)             \
  {                                                           \
       const CPPClassName* ptr = dynamic_cast<CPPClassName*>(const_cast<LBObject*>(&lbo)); \
       if ( ! ptr ) return false;                             \
       *this = *ptr;                                          \
       return true;                                           \
  }                                                           \
  const Luban::LBTypeInfo& CPPClassName::staticTypeInfo()                   \
  {                                                           \
     static Luban::LBTypeInfo lbt(typeid(CPPClassName), #CPPClassName, (Luban::LBTypeInfo::LBConstructor)&CPPClassName::staticConstructor, majorversion, minorversion); \
     return lbt;                                               \
  }                                                               \
  const Luban::LBTypeInfo& CPPClassName::getType() const              \
  {      return staticTypeInfo(); }                                   \
  LBObject* CPPClassName::memberFuncCall(const LBSymbol& funcname, const LBVarArgs* args, LBObject* retvalue) \
  {                                                                                                           \
    LubanCallableFunc f;                                                                                      \
    if ( ! exportedMemeberFuncRegistry().find(funcname, f) )                                                  \
     throw LBException(string("No such member function ")+funcname.toString()+" for "+string(#CPPClassName)); \
    return (*f)(args, retvalue);                                                                              \
  }                                                                                                           \
  LBMemberFuncTable<CPPClassName>& CPPClassName::exportedMemberFuncRegistry()                                 \
  {                                                                                                           \
     static LBMemberFuncTable<CPPClassName> __mfreg__;                                                        \
     return __mfreg__;                                                                                        \
  }                                                                                                           \
  int CPPClassName::exportMemberFunc(const char* lubanname, LubanCallableFunc f, const char* synopsis)    \
  {  return exportedMemberFuncRegistry().addMemberFunc(lubanname, f, synopsis);   }                       \



#define LBEXPORT_MEMBER_FUNC(CPPClassName, memberfuncname, lubanname, synopsis)              \
     static int CPPClassName##_memberfuncname_exported=CPPClassName::exportMemberFunc(lubanname, &CPPClassName::memberfuncname, synopsis);   \








#endif
