#ifndef __CONSOLE_HPP__
#define __CONSOLE_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"

namespace Std
{
  using std::string;
  using std::istream;
  using std::ostream;
  using Luban::LBObject;
  using Luban::LBVarArgs;

  class Console : public LBObject
  {
    LBDECLARE( Std::Console )

    Console();

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // Console specific interfaces
    bool operator==(const Console& x) const
    { return true; }
    bool operator!=(const Console& x) const
    { return false; }

    // Console use functions
    void put(const LBObject& obj) const; // print to stdout
    void putLine(const LBObject& obj) const; // print to stdout, and a CR
    bool readChar(char& c) const; // read one char
    bool readLine(string& aline) const; // read to CR
    bool readAll(string& all) const; // read until eof

    bool putObj(const LBObject& obj) ; // dump binary guts, not for human reading
    LBObject* getObj() ; // restore object from stream

    LBObject* luban_put(const LBVarArgs *args);
    LBObject* luban_putline(const LBVarArgs *args);

    LBObject* luban_get(const LBVarArgs *args);
    LBObject* luban_getline(const LBVarArgs *args);
    LBObject* luban_getall(const LBVarArgs *args);

    LBObject* luban_putobj(const LBVarArgs *args);
    LBObject* luban_getobj(const LBVarArgs *args);

  };

}



#endif
