#ifndef __PORTLISTENER_HPP__
#define __PORTLISTENER_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbobject.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Net
{
  using std::string;
  using std::istream;
  using std::ostream;

  using Luban::LBObject;
  using Luban::LBVarArgs;
  class Socket;

  class Portlistener : public LBObject
  {
    LBDECLARE( Net::Portlistener )
    
    Portlistener(int port); // server side socket 

    // LBObject required interfaces
    string toString() const;   // for human readable printing
    ostream& toStream(ostream& o) const;  // for persistence and network transportation
    // major.minor is the version number of the object IN THE STREAM
    // which are passed in in case it is needed for backward compatible streaming
    istream& fromStream(istream& i, int major=-1, int minor=-1); // for persistence and network transportation
    bool equals(const LBObject& another) const;  

    // Portlistener specific interfaces
    bool operator==(const Portlistener& x) const
    { return false; }
    bool operator!=(const Portlistener& x) const
    { return true; }

    // Portlistener use functions
    Socket *accept();
    void close();
    bool isValid() const;

    LBObject* luban_accept(const LBVarArgs *args);
    LBObject* luban_close(const LBVarArgs *args);

  private:
    class PortlistenerImp
    {
    public:
      PortlistenerImp(int port);
      ~PortlistenerImp();
      bool isValid() const;
      int _port;
      string _errmsg;

      // #ifdef LINUX UNIX
      int _socketid;

    private:
      PortlistenerImp(const PortlistenerImp& s);
      PortlistenerImp& operator=(const PortlistenerImp& s);
    };

    Luban::RefCountedPtr<PortlistenerImp> _portlistenerimp;

  };

}



#endif
