#include "luban/luban_implicitcast.hpp"
#include "luban/lbvmcode.hpp"

#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbdouble.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbobject.hpp"

namespace Luban
{
  // static
  LBObject* LubanImplicitCast::handleDoubleAndInt(const LBObject& op1, const LBObject& op2, LBVMCode::OPCode opc)
  {
    int t1=-1, t2=-1;

    const LBTypeInfo& type1=op1.getType();
    const LBTypeInfo& type2=op2.getType();

    if ( type1 == type2 ) return 0;

    if ( type1 == LBTYPEID(LBDouble) )
      t1 = 1;
    else
      if ( type1 == LBTYPEID(LBInt) )
	t1 = 0;
      else
	return 0;


    if ( type2 == LBTYPEID(LBDouble) )
      t2 = 1;
    else
      if ( type2 == LBTYPEID(LBInt) )
	t2 = 0;
      else
	return 0;

    double db1, db2;
    int it1, it2;

    if ( t1 == 1 )
      {
	const LBDouble& ldb = dynamic_cast<const LBDouble&>(op1);
	db1 = double(ldb);

	const LBInt& lint2 = dynamic_cast<const LBInt&>(op2);
	it2 = int(lint2);
	switch ( opc )
	  {
	  case LBVMCode::ADD:
	    return new LBDouble(db1+double(it2));
	  case LBVMCode::MINUS:
	    return new LBDouble(db1-double(it2));
	  case LBVMCode::MUL:
	    return new LBDouble(db1*double(it2));
	  case LBVMCode::DIV:
	    return new LBDouble(db1/double(it2));
	  }
	return 0;

      }

    const LBInt& lint = dynamic_cast<const LBInt&>(op1);
    it1 = int(lint);

    const LBDouble& ldb2 = dynamic_cast<const LBDouble&>(op2);
    db2 = double(ldb2);

    switch ( opc )
      {
      case LBVMCode::ADD:
	return new LBDouble(double(it1)+db2);
      case LBVMCode::MINUS:
	return new LBDouble(double(it1)-db2);
      case LBVMCode::MUL:
	return new LBDouble(double(it1)*db2);
      case LBVMCode::DIV:
	return new LBDouble(double(it1)/db2);
      }
    return 0;

  }


}
