#ifndef __LBTYPESPECRANGE_HPP__
#define __LBTYPESPECRANGE_HPP__

#include <iosfwd>
#include <string>
#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/LBObjPtr.hpp"

namespace Luban
{
  using std::string;

  class LBObject;

  class LBTypeSpecRange : public LBTypeSpec
  {
    LBDECLARE(Luban::LBTypeSpecRange);
  public:
    explicit LBTypeSpecRange( const LBObject& startp, const LBObject& endp ) ;
    explicit LBTypeSpecRange( LBObject* startp, LBObject* endp ) ;
    ~LBTypeSpecRange() {}

    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    // LBTypeSpec required interface
    bool checkObj(const LBObject& obj) const;

    // LBTypeSpecRange specific member functions
    bool operator==(const LBTypeSpecRange& x) const
    { return _startp == x._startp && _endp == x._endp; }
    bool operator!=(const LBTypeSpecRange& x) const
    {   return ! ( operator==(x) ); }

  private:
    LBTypeSpecRange() : _startp(), _endp() {}
    LBObjPtr _startp;
    LBObjPtr _endp;
  };


}

#endif
