#include "luban/lbstructiopadlocal.hpp"


namespace Luban
{
  bool LBStructInPadLocal::writeValueByExternal(int index, const LBObjPtr& obj)
  {
    _inproperties[index] = obj;
    return true;
  }

  bool LBStructInPadLocal::writeValueByExternal(int index, const LBObject& obj)
  {
    _inproperties[index].assign(obj);
    return true;
  }

  LBObjPtr LBStructInPadLocal::readValueByInternal(int index)
  {
    return _inproperties[index];
  }

  LBObject* LBStructInPadLocal::readUnsharedGuts(int index)
  {
    if ( ! _inproperties[index] )
      return 0;
    uniclone(_inproperties[index]);
    return _inproperties[index].getRealPtr();
  }

  int LBStructInPadLocal::size() const
  {
    return _inproperties.size();
  }

  LBStructInPadLocal *LBStructInPadLocal::clone()const
  {
    return new LBStructInPadLocal(*this);
  }

  LBStructOutPadLocal *LBStructOutPadLocal::clone() const
  {
    return new LBStructOutPadLocal(*this);
  }


  bool LBStructOutPadLocal::writeValueByInternal(int index, const LBObjPtr& obj)
  {
    _outproperties[index] = obj;
    return true;
  }

  bool LBStructOutPadLocal::writeValueByInternal(int index, const LBObject& obj)
  {
    _outproperties[index].assign(obj);
    return true;
  }

  LBObjPtr LBStructOutPadLocal::readValueByExternal(int index)
  {
    return _outproperties[index];
  }

  int LBStructOutPadLocal::size() const
  {
    return _outproperties.size();
  }


}
