#include "lbtypes/lbexception.hpp"
#include "luban/lbstructiopadasynch.hpp"

namespace Luban
{
  bool LBStructInPadAsynch::writeValueByExternal(int index, const LBObjPtr& obj)
  {
    LBMutexLocker mlock( _mtx );
    if ( _dismissed ) return false;
    _inproperties[index].push_back(obj);
    ++_objtoread;
    if (  _waitingreaders > 0 )
      _newarrival.broadcast();
    return true;
  }

  bool LBStructInPadAsynch::writeValueByExternal(int index, const LBObject& obj)
  {
    LBObjPtr objp(obj.clone());
    {
      LBMutexLocker mlock( _mtx );
      if ( _dismissed ) return false;
      _inproperties[index].push_back(objp);
      ++_objtoread;
      if (  _waitingreaders > 0 )
	_newarrival.broadcast();
    }
    return true;
  }

  LBObjPtr LBStructInPadAsynch::readValueByInternal(int index)
  {
    if ( _dismissed )
      throw LBException( "The asynch struct is being detroyed");
    LBMutexLocker mlock( _mtx );
    if ( _dismissed )
      throw LBException( "The asynch struct is being detroyed");
    while ( _inproperties[index].size() == 0 )
      {
	++_waitingreaders;
	if ( _objtoread == 0 )
	  _emptyq.broadcast();
	_newarrival.wait(_mtx);
	--_waitingreaders;
	if ( _dismissed )
	  throw LBException( "The asynch struct is being detroyed");
      }
    LBObjPtr result(_inproperties[index].front());
    _inproperties[index].pop_front();
    --_objtoread;
    return result;
  }

  int LBStructInPadAsynch::waitForNewInput()
  {
    LBMutexLocker mlock( _mtx );
    if ( _dismissed )
      return 0;

    while ( _objtoread == 0 )
      {
	++_waitingreaders;
	_emptyq.broadcast();
	_newarrival.wait(_mtx);
	--_waitingreaders;

	if ( _dismissed )
	  return 0;
      }
    return _objtoread;
  }

  void LBStructInPadAsynch::waitUntilInputEmpty()
  {
    LBMutexLocker mlock( _mtx );
    if ( _dismissed )
      return;
    if (  _objtoread > 0 || _waitingreaders == 0 )
      _emptyq.wait(_mtx);
    return;
  }

  void LBStructInPadAsynch::dismissWaitingThreads()
  {
    LBMutexLocker mlock( _mtx );
    _dismissed = true;
    _newarrival.broadcast();
    _emptyq.broadcast();
  }
      

  LBObject* LBStructInPadAsynch::readUnsharedGuts(int index)
  {
    throw LBException("Can not get guts from asynch Input/Output queue");
  }



  LBStructInPadAsynch::LBStructInPadAsynch(int sz )
    : _inproperties(sz), _objtoread(0),_waitingreaders(0), _dismissed(false), _mtx(), _newarrival()
  {
  }

  LBStructInPadAsynch::~LBStructInPadAsynch()
  {
  }


  bool LBStructOutPadAsynch::writeValueByInternal(int index, const LBObjPtr& obj)
  {
    LBMutexLocker mlock( _mtx );
    if ( _closed ) return false;
    _outproperties[index].push_back(obj);
    if ( _waitingreaders > 0 )
      _newarrival.broadcast();
    return true;
  }

  bool LBStructOutPadAsynch::writeValueByInternal(int index, const LBObject& obj)
  {
    LBObjPtr objp(obj.clone());
    {
      LBMutexLocker mlock( _mtx );
      if ( _closed ) return false;
      _outproperties[index].push_back(objp);
      if ( _waitingreaders > 0 )
	_newarrival.broadcast();
    }
    return true;
  }

  LBObjPtr LBStructOutPadAsynch::readValueByExternal(int index)
  {
    LBMutexLocker mlock( _mtx );

    while ( _outproperties[index].size() == 0 )
      {
	if ( _closed )
	  throw LBException( "The asynch struct is being detroyed");

	_waitingreaders++;
	_newarrival.wait(_mtx);
	_waitingreaders--;
      }
    LBObjPtr result(_outproperties[index].front());
    _outproperties[index].pop_front();
    return result;
  }

  void LBStructOutPadAsynch::dismissWaitingThreads()
  {
    LBMutexLocker mlock( _mtx );
    _closed = true;
    if ( _waitingreaders )
      _newarrival.broadcast();
  }

  LBStructOutPadAsynch::LBStructOutPadAsynch(int sz )
    : _outproperties(sz), _waitingreaders(0), _mtx(), _newarrival(), _closed(false)
  {
  }

  LBStructOutPadAsynch::~LBStructOutPadAsynch()
  {
  }

}
