#include "lbtypes/lbexception.hpp"
#include "lbthread/lbthread.hpp"

#include "luban/lbrwlockedobjptr.hpp"
#include "luban/lbstruct.hpp"


namespace Luban
{
  LBWriteLockedObjPtr::LBWriteLockedObjPtr()
    : _imp()
  {
  }
  LBWriteLockedObjPtr::LBWriteLockedObjPtr(const LBWriteLockedObjPtr& p)
    : _imp()
  {
    LBWriteLockedObjPtr& pvref = const_cast<LBWriteLockedObjPtr&>(p);
    _imp = pvref._imp;
  }
  LBWriteLockedObjPtr::LBWriteLockedObjPtr(LBReadWriteLock *rwlock, LBObject *obj )
    : _imp( new LBWriteLockedObjPtrImp(rwlock, obj))
  {
  }

  LBWriteLockedObjPtr::~LBWriteLockedObjPtr()
  {
  }

  void LBWriteLockedObjPtr::pushObj(LBObject *obj)
  {
    if ( _imp.get() )
      _imp->_frontObj = obj;
  }

  void LBWriteLockedObjPtr::addTouch(LBStruct *st, int propertyIndex, LBPropertyInfo::ExecAttr attr)
  {
    if ( _imp.get() )
      {
	if ( ! _imp->_touchList )
	  _imp->_touchList = new std::vector<StructPropertyInfo>();
	_imp->_touchList->push_back(StructPropertyInfo(st, propertyIndex, attr));
      }
  }

  LBObject*   LBWriteLockedObjPtr::operator->()
  {
    if ( _imp.get() )
      return _imp->_frontObj;
    return 0;
  }

  const LBObject* LBWriteLockedObjPtr::operator->() const
  {
    if ( _imp.get() )
      return _imp->_frontObj;
    return 0;
  }

  LBObject& LBWriteLockedObjPtr::operator*()
  {
    if ( _imp.get() && _imp->_frontObj )
      return *_imp->_frontObj;
    throw(LBException("Attempt to dereference zero pointer in lBWriteLockedObjPtr"));
  }

  const LBObject& LBWriteLockedObjPtr::operator*() const
  {
    if ( _imp.get() && _imp->_frontObj )
      return *_imp->_frontObj;
    throw(LBException("Attempt to dereference zero pointer in lBWriteLockedObjPtr"));
  }
 
  LBWriteLockedObjPtr::operator bool() const
  {
    return _imp.get() && _imp->_frontObj;
  }

  LBObject* LBWriteLockedObjPtr::getRealPtr()
  {
    return _imp.get()?_imp->_frontObj:0;
  }

  void LBWriteLockedObjPtr::pushLock(const LBWriteLockedObjPtr& p)
  {
    LBWriteLockedObjPtr& pvref = const_cast<LBWriteLockedObjPtr&>(p);
    if ( ! _imp.get() )
      {
	_imp = pvref._imp;
	return;
      }

    if ( pvref._imp.get() )
      {
	if ( pvref._imp->_rwlockvec )
	  {
	    if ( ! _imp->_rwlockvec )
	      {
		_imp->_rwlockvec = pvref._imp->_rwlockvec;
		pvref._imp->_rwlockvec = 0;
	      }
	    else
	      {
		for( int i=0; i<pvref._imp->_rwlockvec->size(); i++)
		  _imp->_rwlockvec->push_back((*pvref._imp->_rwlockvec)[i]);
		pvref._imp->_rwlockvec->clear();
	      }
	  }

	_imp->_frontObj = p._imp->_frontObj;

      }

  }

  void LBWriteLockedObjPtr::invalidate()
  {
    if ( _imp.get() )
      _imp->_touch = false;
  }

  LBWriteLockedObjPtr::LBWriteLockedObjPtrImp::LBWriteLockedObjPtrImp(LBReadWriteLock *rwlock, LBObject *obj)
    : _rwlockvec(0), _frontObj(obj), _touchList(0), _touch(true)
  {
    if ( rwlock )
      {
	_rwlockvec = new std::vector<LBReadWriteLock*>();
	rwlock->writeLock();
	_rwlockvec->push_back(rwlock);
      }
  }

  LBWriteLockedObjPtr::LBWriteLockedObjPtrImp::~LBWriteLockedObjPtrImp()
  {
    if ( _touchList &&  _touch )
      {
	for( int i = _touchList->size()-1; i >= 0; i--)
	  (*_touchList)[i].st->touchProperty((*_touchList)[i].propertyIndex, (*_touchList)[i].attr);
      }

    if ( _rwlockvec )
      for( int i=0; i < _rwlockvec->size(); i++ )
	if ( (*_rwlockvec)[i]) (*_rwlockvec)[i]->unlock();

    delete _rwlockvec;
    delete _touchList;
    
  }

  LBWriteLockedObjPtr& LBWriteLockedObjPtr::operator=(const LBWriteLockedObjPtr& p)
  {
    LBWriteLockedObjPtr& pvref = const_cast<LBWriteLockedObjPtr&>(p);
    _imp = pvref._imp;
    return *this;
  }


}
