#ifndef __LBCOMPONENTINFO_HPP__
#define __LBCOMPONENTINFO_HPP__

#include <string>
#include <vector>
#include <iosfwd>

#include "lbthread/lbthread.hpp"

#include "lbtypes/lbfullsymbol.hpp"
#include "lbtypes/lbsymbol.hpp"

#include "luban/luban_parsetree.hpp"

namespace Luban
{
  class LBTypeSpec;
  class LBStruct;
  class LBStructInterface;
  using std::string;

  class LBComponentInfo
  {
  public:
    friend class LubanSymbolResolver;
    friend class LBNSUtil;

    ~LBComponentInfo();

  private:

    enum ComponentType { STRUCT, TYPEDEF, PRIMITIVETYPE, INVALID };
    enum Status { NONINITED, INTERFACEREADY, ALLREADY, BEINGPROCESSED, ERROR };

    LBComponentInfo(const LBFullSymbol& fullname, Tree parsetree)
      : _name(), _homens(fullname),_fullname(fullname), _parsetree(parsetree), 
	_typedefextsymbols(0), _lubantype(0), _structinterface(0), _struct(0),
	_status(NONINITED), _errmsg(), _type(INVALID), _instantiationMut(), _interfaceResolvingInProcess(false)
    {
      _homens.pop(_name);
      if ( parsetree )
	_type = treeTypeToComponentType(parsetree->nodeType());
    }

    LBComponentInfo(const LBFullSymbol& ptypename)
      : _name(), _homens(ptypename),_fullname(ptypename), _parsetree(0), 
	_typedefextsymbols(0), _lubantype(0), _structinterface(0), _struct(0),
	_status(NONINITED), _errmsg(), _type(PRIMITIVETYPE), _instantiationMut(), _interfaceResolvingInProcess(false)
    {
      _homens.pop(_name);
    }
    
    const LBFullSymbol& fullname() const
    {   return _fullname; }
    const LBSymbol& name() const
    {   return _name; }
    ComponentType componentType() const
    { return _type; }


    void invalidate(const string& errmsg);
    const string& errormsg() const;

    // The following is used by DSR to save/retrieve the symbol to/from LCR
    ostream& toStream(ostream& ost) const;
    istream& fromStream(istream& ist);

    static ComponentType treeTypeToComponentType(TreeNode::NodeType nt)
    {
      	switch ( nt )
	  {
	  case TreeNode::ABSTRACTSTRUCT:
	  case TreeNode::STATIONARYSTRUCTDECLARE:
	  case TreeNode::PROCESSSTRUCT:
	  case TreeNode::COMPOSITIONSTRUCT:
	    return STRUCT;
	  case TreeNode::TYPENAMEDEF:
	    return TYPEDEF;
	  default:
	    ;
	  }
	return INVALID;
    }

  private:
    LBComponentInfo();
    LBComponentInfo(const LBComponentInfo& c);
    LBComponentInfo& operator=(const LBComponentInfo& c);

  private:
    // data members
    LBSymbol _name;
    LBFullSymbol _homens;
    LBFullSymbol _fullname;
    TreeNode *_parsetree;

    LBFullSymbolVec *_typedefextsymbols;
    LBTypeSpec *_lubantype;
    LBStructInterface *_structinterface;
    LBStruct *_struct;

    Status _status;
    string _errmsg;
    ComponentType _type;

    LBMutex _instantiationMut;
    bool _interfaceResolvingInProcess;
  };
}

#endif
