#include <iostream>

#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbsymbol.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbdouble.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbchar.hpp"
#include "lbtypes/lbbool.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbvector.hpp"
#include "lbtypes/lbiterator.hpp"
#include "lbtypes/lbmap.hpp"
#include "lbtypes/lbset.hpp"
#include "lbtypes/lbvarargs.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbfullsymbol.hpp"
#include "lbtypes/lbtypespecbasic.hpp"
#include "lbtypes/lbtypespecmultitype.hpp"
#include "lbtypes/lbtypespecenum.hpp"
#include "lbtypes/lbtypespecrange.hpp"
#include "lbtypes/lbtypespectypetype.hpp"
#include "lbtypes/lberror.hpp"

using std::string;

int main(int argc, char *argv[])
{
  using Luban::LBSymbol;
  using Luban::LBString;
  using Luban::LBDouble;
  using Luban::LBInt;
  using Luban::LBChar;
  using Luban::LBBool;
  using Luban::LBVector;
  using Luban::LBObject;
  using Luban::LBConstIterator;
  using Luban::LBMap;
  using Luban::LBSet;
  using Luban::LBVarArgs;
  using Luban::LBException;
  using Luban::LBFullSymbol;
  using Luban::LBTypeSpecBasic;
  using Luban::LBTypeSpecMultiType;
  using Luban::LBTypeSpecEnum;
  using Luban::LBTypeSpecRange;
  using Luban::LBTypeSpecTypeType;
  using Luban::LBError;
  using std::cin;
  using std::cout;
  using std::cerr;


  try {

  LBSymbol lbs1(" LBSymbol's Hello World! \n");
  LBSymbol lbs2(" LBSymbol's Hello World! \n Again! \n ");

  cerr << "Stream out:\n";

  Luban::LBObject::instanceToStream(cout, lbs1);
  Luban::LBObject::instanceToStream(cout, lbs2);
  Luban::LBObject::instanceToStream(cout, LBDouble(3.1415926535897932));
  Luban::LBObject::instanceToStream(cout, LBInt(123456789));
  Luban::LBObject::instanceToStream(cout, LBString("LBString's Hello world! \n this is LBString! \n "));
  Luban::LBObject::instanceToStream(cout, LBString("LBString's Hello world #2! \n this is LBString, again! \n "));
  Luban::LBObject::instanceToStream(cout, LBString("LBString's Hello world #2! \n this is LBString, again! \n ").neg());
  Luban::LBObject::instanceToStream(cout, LBString("LBString's Hello world #2! \n this is LBString, again! \n ").mul(LBInt(2)));
  Luban::LBObject::instanceToStream(cout, LBChar('\t'));
  Luban::LBObject::instanceToStream(cout, LBChar('a'));
  Luban::LBObject::instanceToStream(cout, LBBool(true));
  Luban::LBObject::instanceToStream(cout, LBBool(false));
  Luban::LBObject::instanceToStream(cout, LBError("This is an error message test"));


  LBVector v;
  Luban::LBObject::instanceToStream(cout, v);

  v.insert(LBDouble(3.1415926535897932));
  v.insert(LBInt(123456789));
  v.insert(LBString("HelloWorld"));
  v.insert(LBString("HelloWorld2").mul(LBInt(2)));
  v.insert(LBChar('z'));
  v.insert(LBChar('a'));
  v.insert(LBBool(true));
  v.insert(LBBool(false));
  v.insert((LBObject*)0);

   LBVector vcopy;
   vcopy = v;
   vcopy.erase(2,3);
   v.insert(vcopy,2);
   LBObject* m1 = v.pop_front();
   Luban::LBObject::instanceToStream(cout, v);
   v.sort();
   Luban::LBObject::instanceToStream(cout, v);

   LBVector* v2=v.subVector(1,5);
   Luban::LBObject::instanceToStream(cout, *v2);

   v2->erase(1,2);
   v2->insert(m1, 3);

   Luban::LBObject::instanceToStream(cout, *v2);
   LBConstIterator *it = v2->getIterator();
   while ( it->next() )
     {
       if ( it->getCurrentRow()->getArg(0) )
	 Luban::LBObject::instanceToStream(cout, *it->getCurrentRow()->getArg(0));
     }
   delete it;
   delete v2;

   Luban::LBObject::instanceToStream(cout, vcopy);

   LBMap mp;
   Luban::LBObject::instanceToStream(cout, mp);

   LBString ray("Ray");
   mp.insert(ray, LBInt(1));
   mp.insert(LBString("Hua"), LBInt(2));
   mp.insert(LBString("Me"), LBInt(3));
   mp.insert((LBObject*)0,(LBObject*)0);
   mp.insert(LBString("World"), LBInt(4));
   LBDouble pi(3.1415926);
   mp.insert(pi, LBString("Pi"));   

   Luban::LBObject::instanceToStream(cout, mp);

   mp.erase(pi);

   Luban::LBObject::instanceToStream(cout, mp);

   LBConstIterator *it2 = mp.getIterator();
   while ( it2->next() )
     {
       if ( it2->getCurrentRow()->getArg(0) )
	 Luban::LBObject::instanceToStream(cout, *it2->getCurrentRow()->getArg(0));
       if ( it2->getCurrentRow()->getArg(1) )
	 Luban::LBObject::instanceToStream(cout, *it2->getCurrentRow()->getArg(1));
     }

   delete it2;

   // the below are to show the affect of getting object reference out of the container
  LBInt ten(10), twenty(20);
  LBMap mp2(mp);
  mp[ray].assign(ten); // this is good , assignment only affect  mp, not mp2
  Luban::LBObject::instanceToStream(cout, mp);
  Luban::LBObject::instanceToStream(cout, mp2);

  LBObject &r = mp2[ray];
  LBMap mp3(mp2);
  r.assign(twenty); // this could be supurising, it will change both mp3 and mp2
  Luban::LBObject::instanceToStream(cout, mp2);
  Luban::LBObject::instanceToStream(cout, mp3);


   LBSet st;
   Luban::LBObject::instanceToStream(cout, st);

   st.insert(ray);
   st.insert(ray);
   st.insert(LBString("Hua"));
   st.insert(LBString("Hua"));
   st.insert(LBString("Me"));
   st.insert(LBString("World"));
   st.insert(pi);   
   st.insert(pi);   
   st.insert((LBObject*)0);   

   Luban::LBObject::instanceToStream(cout, st);

   st.erase(pi);
   st.erase(LBString("World"));

   Luban::LBObject::instanceToStream(cout, st);

   LBConstIterator *it3 = st.getIterator();
   while ( it3->next() )
     {
       if ( it3->getCurrentRow()->getArg(0) )
	 Luban::LBObject::instanceToStream(cout, *it3->getCurrentRow()->getArg(0));
     }

   delete it3;

   LBFullSymbol fsym;
   fsym.append(LBSymbol("World"));
   fsym.append(LBSymbol("Home"));
   fsym.append(LBSymbol("Ray"));

   Luban::LBObject::instanceToStream(cout, fsym);
   LBFullSymbol fsym2;
   fsym2.insertFront(LBSymbol("Ray"));
   fsym2.insertFront(LBSymbol("Home"));
   fsym2.insertFront(LBSymbol("World"));
   Luban::LBObject::instanceToStream(cout, fsym2);

   LBFullSymbol::stringToFullSymbol(string("Universe::Earth::Home::Ray"),fsym2);
   Luban::LBObject::instanceToStream(cout, fsym2);
   LBSymbol raysym;
   fsym2.pop(raysym);
   Luban::LBObject::instanceToStream(cout, raysym);
   Luban::LBObject::instanceToStream(cout, fsym2);

   LBTypeSpecBasic typebasic(&fsym.getType());
   if ( typebasic.checkObj(fsym) )
     Luban::LBObject::instanceToStream(cout, typebasic);

   LBTypeSpecBasic typebasic2;
   if ( typebasic2.checkObj(fsym) )
     Luban::LBObject::instanceToStream(cout, typebasic2);

   LBTypeSpecMultiType mtp;
   mtp.addType(typebasic.clone());
   mtp.addType(new LBTypeSpecBasic(&LBTYPEID(LBDouble)));
   mtp.addType(new LBTypeSpecBasic(&LBTYPEID(LBInt)));
   if ( mtp.checkObj(LBInt(1)) && mtp.checkObj(LBDouble(1.0)))
     Luban::LBObject::instanceToStream(cout, mtp);

   LBTypeSpecEnum enumtp;
   Luban::LBObject::instanceToStream(cout, enumtp);
   enumtp.addEnum(LBInt(2));
   enumtp.addEnum(LBInt(3));
   enumtp.addEnum(LBInt(5));
   enumtp.addEnum(LBInt(7));
   enumtp.addEnum(LBInt(11));
   enumtp.addEnum(LBChar('a'));
   if ( enumtp.checkObj(LBInt(2)) && enumtp.checkObj(LBChar('a')) && !enumtp.checkObj(LBInt(10)) )
     Luban::LBObject::instanceToStream(cout, enumtp);

   LBTypeSpecRange validrange(LBInt(1), LBInt(100));       
   Luban::LBObject::instanceToStream(cout, validrange);
   if ( validrange.checkObj( LBInt(50) ) && ! validrange.checkObj(LBInt(1000) ) && !validrange.checkObj(LBDouble(10) ) )
     Luban::LBObject::instanceToStream(cout, validrange);

   LBTypeSpecTypeType tptp;
   if ( tptp.checkObj(enumtp) && tptp.checkObj(mtp) && tptp.checkObj(validrange) )
     Luban::LBObject::instanceToStream(cout, tptp);

   

  }
  catch (LBException e)
    {
      cerr << e.msg() <<"\n";
    }
  

}
