#include "lbtypes/lbobject.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/lbexception.hpp"
#include <iostream>

using std::istream;
using std::ostream;
using std::string;
using std::cout;
using std::cerr;


void getOneObjFromStream(istream& ist)
{
  try {
  string e;
  Luban::LBObject* lbptr = Luban::LBObject::instanceFromStream(ist, e);

  if ( lbptr )
    {
      cout << lbptr->getType() << " value=";
      cout << *lbptr << "\n\n";
      delete lbptr;
    }
  else
    cerr << e << "\n";
  }
  catch (Luban::LBException e)
    {
      cerr << e.msg() << "\n";
    }
}

int main(int argc, char *argv[])
{
  using std::cin;
  using std::cout;

  while ( !cin.eof() )
    getOneObjFromStream(cin);
  return 0;
}
