#ifndef __LBTYPESPECMULTITYPE_HPP__
#define __LBTYPESPECMULTITYPE_HPP__

#include <iosfwd>
#include <vector>

#include "lbtypes/lbtypespec.hpp"
#include "lbtypes/LBDeclareMacros.hpp"
#include "lbtypes/RefCountedPtr.hpp"

namespace Luban
{
  using std::vector;

  class LBTypeSpecMultiType : public LBTypeSpec
  {
    LBDECLARE(Luban::LBTypeSpecMultiType);
  public:
    LBTypeSpecMultiType();
    ~LBTypeSpecMultiType();

    
    // LBObject required interfaces
    string toString() const;
    ostream& toStream( ostream& o ) const ;
    istream& fromStream( istream& i, int major=-1, int minor=-1 );
    bool equals(const LBObject& another) const;

    //LBObject optional interfaces
    int size() const;

    // LBTypeSpec required interface
    bool checkObj(const LBObject& obj) const;

    // LBTypeSpecMultiType specific interface
    void addType(LBTypeSpec *t);
    bool operator==(const LBTypeSpecMultiType& m) const;
    bool operator!=(const LBTypeSpecMultiType& m) const
    { return ! ( operator==(m) ); }

  private:
    class LBTypeSpecMultiTypeImp
    {
    public:
      ~LBTypeSpecMultiTypeImp();
    private:
      LBTypeSpecMultiTypeImp() : _typespecvec() {}

      friend class LBTypeSpecMultiType;

      vector<LBTypeSpec*> _typespecvec;
    };

    typedef RefCountedPtr<LBTypeSpecMultiTypeImp> LBTypeSpecMultiTypeImpPtr;
    
    static const LBTypeSpecMultiTypeImpPtr& defaultGuts()
    {
      static LBTypeSpecMultiTypeImpPtr dftimp( new LBTypeSpecMultiTypeImp() );
      return dftimp;
    }

    LBTypeSpecMultiTypeImpPtr _imp;

  };



}

#endif
