#include <string>
#include <typeinfo>
#include <iostream>
#include "lbtypes/lbbool.hpp"
#include "lbtypes/lbint.hpp"
#include "lbtypes/lbstring.hpp"
#include "lbtypes/lbtypefactory.hpp"
#include "lbtypes/lbtypeinfo.hpp"
#include "lbtypes/LBDefineMacros.hpp"
#include "lbtypes/lbexception.hpp"
#include "lbtypes/lbvarargs.hpp"


namespace Luban
{
  using std::string;

  LBDEFINE(Luban::LBBool, 1, 0)

  LBDEFAULT_EQUALS_FUNC( Luban::LBBool )

  LBBool* LBBool::staticConstructor(const LBVarArgs* args)
  {
    // default constructor, required
    if ( args == 0 || args->numArgs() == 0 )
      return new LBBool();
    
    switch ( args->numArgs() ) {
    case 1:
      {
	const LBObject* arg0 = args->getArg(0);
	if ( arg0 == 0 )
	  return 0;
	// copy constructor
	const LBBool *cptr = dynamic_cast<const LBBool*>(arg0);
	if ( cptr )
	  return new LBBool(*cptr);
	const LBInt *iptr = dynamic_cast<const LBInt*>(arg0);
	if ( iptr )
	  return new LBBool((bool)int(*iptr));
	break;
      }
    default:
      ;
    }
    
    return 0;
  }

  string LBBool::toString() const
  {
    static const string t("true"), f("false");
    if ( _realbool )
      return t;
    return f;
  }

  ostream& LBBool::toStream(ostream& ost) const
  {
    if ( _realbool )
      return ost.put('1');
    return ost.put('0');
  }

  istream& LBBool::fromStream(istream& ist, int major, int minor)
  {
    char c='\0';
    if ( ist.get(c) )
      if ( c == '1' )
	_realbool = true;
      else
	if ( c == '0' )
	  _realbool = false;
	else
	  throw LBException(string("Corrupted stream, failed to restore LBBool instance"));
    else
      throw LBException(string("Corrupted stream, failed to restore LBBool instance"));
    
    return ist;
  }

  bool LBBool::cast(LBObject* target) const
  {
    LBInt *intptr = dynamic_cast<LBInt*>(target);
    if ( intptr )
      {
	*intptr = LBInt(int(_realbool));
	return true;
      }
    LBString *sptr = dynamic_cast<LBString*>(target);
    if ( sptr )
      {
	static const LBString t("true"), f("false");
	if ( _realbool )
	  *sptr = t;
	else
	  *sptr = f;
	return true;
      }

    return false;
  }

  bool LBBool::before(const LBObject& lbo) const
  {
    const LBBool* lboptr = dynamic_cast<const LBBool*>(&lbo);
    if ( lboptr )
	return _realbool < lboptr->_realbool;

    throw LBException(string("Can not compare LBBool with ")+lbo.getType().toString());
  }


}
